% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlowHist.R
\name{viewFlowChannels}
\alias{viewFlowChannels}
\title{viewFlowChannels}
\usage{
viewFlowChannels(file, emptyValue = TRUE, truncate_max_range = TRUE)
}
\arguments{
\item{file}{character, the name of an FCS data file; or the name of a
FlowHist object.}

\item{emptyValue}{boolean, passed to \code{\link{read.FCS}},
needed to deal with unusual FCS file formats. Default is TRUE - if
your file loads without errors, then don't change this value}

\item{truncate_max_range}{boolean, passed to \code{\link{read.FCS}}.}
}
\value{
A vector of column names from the FCS file/FlowHist object.
}
\description{
Displays the column names present in an FCS file
}
\details{
A convenience function for viewing column names in a FCS data file, or a
FlowHist object. Used to select one for the \code{channel} argument
in \code{\link{FlowHist}}, or for viewing additional channels for use in
gating.
}
\examples{
library(flowPloidyData) 
viewFlowChannels(flowPloidyFiles()[1])
}
\seealso{
\code{\link{FlowHist}}
}
\author{
Tyler Smith
}
