% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowGate.R
\name{setGate}
\alias{setGate}
\alias{isGated}
\title{setGate}
\usage{
setGate(fh, gate, refresh = TRUE)

isGated(fh)
}
\arguments{
\item{fh}{a \code{\link{FlowHist}} object}

\item{gate}{boolean, a vector indicating which rows in the raw data
should be included (gated) in the analysis.}

\item{refresh}{boolean, should the analysis be updated after applying
the gate (default = TRUE)?}
}
\value{
\code{setGate} returns an updated \code{\link{FlowHist}} object,
  with the \code{histData} slot updated to account for the gate. With
  \code{refresh = TRUE} (default), it will also rebuild the model and
  complete the analysis.

  \code{isGated} returns TRUE if the \code{\link{FlowHist}} object is
  gated.
}
\description{
Apply a gate to a FlowHist object
}
\details{
This function is primarily book-keeping to make sure that
\code{histData} and downstream calculations are appropriately updated
when a gate is applied. The code for applying the gate is actually in
the function \code{\link{setBins}}.
}
\seealso{
\code{\link{setBins}}
}
\author{
Tyler Smith
}
\keyword{internal}
