% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_graph.R
\name{set_layout_graph}
\alias{set_layout_graph}
\title{Determines cell hierarchy layout.}
\usage{
set_layout_graph(gr, layout_fun = "layout.reingold.tilford")
}
\arguments{
\item{gr}{A list containing data frames \code{e} and \code{v}.}

\item{layout_fun}{A string of a function from the \code{igraph} package that
indicates what layout should be used if a cell hierarchy is to be ploted;
all such functions have prefix \code{layout_}
e.g. \code{layout_fun="layout.reingold.tilford"}.}
}
\value{
A list containing data frames \code{e} and \code{v}; each data frame
   contains an X, Y column or coordinate for each node and edge.
}
\description{
Determines cell hierarchy layout and returns the X, Y coordinate
   of each cell population.
}
\examples{

   no_cores <- 1
   data(fg_data_pos30)
   fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                                   prop=FALSE, specenr=FALSE,
                                   no_cores=no_cores)

   head(set_layout_graph(fg_get_graph(fg)))

}
