% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_flowgraph_class.R
\docType{class}
\name{flowGraph-class}
\alias{flowGraph-class}
\alias{show,flowGraph-method}
\title{'flowGraph': A class for storing cell count feature values
 for the Phenotype class.}
\usage{
\S4method{show}{flowGraph}(object)
}
\arguments{
\item{object}{A flowGraph object.}
}
\value{
a flowGraph object.
}
\description{
'flowGraph': A class for storing cell count feature values
 for the Phenotype class.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: show method
}}

\section{Slots}{

\describe{
\item{\code{feat}}{A list containing elements \code{node} and \code{edge},
each containing a list with feature values;
  each element in this list is named by the feature name and contains a
  numeric matrix with the sample id's as row names and cell populations
  phenotype labels or edge labels as column names. Column names
  for edge features are labelled as <from>_<to> e.g. A+_A+B+.}

\item{\code{feat_desc}}{A list containing elements \code{node} and \code{edge},
each containing a data frame describing the features in the \code{feat} slot
with columns:
\itemize{
  \item{\code{feat}: feature name.}
  \item{\code{nrow}: number of samples.}
  \item{\code{ncol}: number of nodes or edges.}
  \item{\code{inf}: number of infinite values in the matrix.}
  \item{\code{neginf}: number of negative infinite values in the matrix.}
  \item{\code{na}: number of NA values in the matrix.}
  \item{\code{nan}: number of NaN values in the matrix.}
  \item{\code{neg}: number of negative values in the matrix.}
  \item{\code{pos}: number of positive values in the matrix.}
  \item{\code{zero}: number of 0's in the matrix.}
  \item{\code{max}: The maximum value in the matrix.}
  \item{\code{min}: The minimum value in the matrix.}
}}

\item{\code{summary}}{A list containing elements \code{node} and \code{edge},
 each containing a list with a feature summary list;
 each feature summary in this list contains elements:
\itemize{
  \item{\code{values}: a numeric vector the same length
   as the number of nodes or edges.}
  \item{test_custom: a function or a string name
   of the summary test method used.}
}}

\item{\code{summary_desc}}{A list containing elements \code{node} and \code{edge},
 each containing a data frame describing the features in \code{feat} with
 columns:
\itemize{
  \item{\code{feat}: A string indicating feature name the
   summary was created for.}
  \item{\code{test_name}: A string containing the name of the summary.}
  \item{\code{class}: A string corresponding to the column name
   of the \code{meta} slot whose values represent the class label of
   each sample on which the summary was created to compare or analyze.}
   \item{\code{label1}: A string from the \code{class} column of the
    \code{meta} slot indicating one of the labels compared to create
    the summary statistic.}
   \item{\code{label2}: A string from the \code{class} column of the
    \code{meta} slot indicating one of the labels compared to create
    the summary statistic.}
}}

\item{\code{meta}}{A data frame containing the column(s) \code{id} (sample id's
corresponding to row names of features in the \code{feat} slot) and any
other meta data pertaining to samples being analyzed.}

\item{\code{markers}}{A character vector containing markers used.}

\item{\code{edge_list}}{A list containing elements \code{child} and \code{parent}.
These elements contain an edge list from child to parent and vice versa.}

\item{\code{graph}}{A list containing data frames \code{v} and \code{e} with
information on cell population nodes and edges. \code{v} contains columns:
\itemize{
  \item{\code{phenotype}: The cell population node label names e.g. A+B+C+.}
  \item{\code{phenocode}: A string of "0", "1", "2", ... indicating the
   whether each marker is expressed on a cell population.}
  \item{\code{phenolayer}: The layer on which a cell population resides i.e.
   the numer of markers in its phenotype label.}
  \item{\code{phenogroup}: The markers used the make up the phenotype.}
}}

\item{\code{plot_layout}}{A string indicating the name of the \code{igraph} layout
function used to layout the cell population nodes for plotting.}

\item{\code{etc}}{A list containing other information
(see \code{\link[flowGraph]{fg_get_summary}} for other things stored
in this slot):
\itemize{
  \item{\code{cumsumpos}: A logical indicating whether cell counts
   in \code{flowGraph} object contains cumulated cell counts;
   this is optional and can be done only for there is
   more than one threshold for one or more markers.
   This should also only be ran when initializing a \code{flowGraph} object
   as converting back and forth is computationally expensive.
   If the user is interested in seeing non- and cumulated counts,
   we recommend keeping two \code{flowGraph} objects, one for each version.
   This function simply converts e.g. the count of A+ or A++ into
   the sum of count of A+, A++, and A+++ or A++, and A+++.}
  \item{\code{class_mean_normalized}: A logical indicating whether the
   features in the flowGraph object has been normalized according to
   some sample meta e.g. subject.}
   \item{\code{save}: A list containing a string indicating the save ID
    of the object
and a string indicating path where the object is saved -- used in function
\code{save_fg} to identify whether or not to save to the same folder.}
}}
}}

\section{Creating Objects}{
 Objects can be created using
\code{new("flowFrame")} or the constructor \code{flowGraph},
with mandatory argument \code{input_}.
Creating objects using \code{new} is discouraged.
}

\section{Methods}{
 'object' represents a \code{flowGraph} object.
\itemize{
  \item{\code{show(fg)}: Shows a description of the \code{flowGraph} object.}
  \item{\code{fg_get_meta}: Retrieves the sample meta data
   from a given \code{flowGraph} object.
   See \code{\link[flowGraph]{fg_get_meta}}.}
  \item{\code{fg_get_graph}: Retrieves the cell population (v) and edge (e)
   meta data from a given \code{flowGraph} object.
   See \code{\link[flowGraph]{fg_get_graph}}.}
  \item{\code{fg_get_feature}: Retrieves the numeric feature matrix requested
   by the user from a given \code{flowGraph} object.
   See \code{\link[flowGraph]{fg_get_feature}}.}
  \item{\code{fg_get_summary}: Retrieves the feature summary list requested
   by the user from a given \code{flowGraph} object.
   See \code{\link[flowGraph]{fg_get_summary}}.}
  \item{\code{fg_get_feature_desc}: Retrieves the data frame from the
   \code{feat_desc} slot of a given \code{flowGraph} object.
   See \code{\link[flowGraph]{fg_get_feature_desc}}.}
  \item{\code{fg_get_summary_desc}: Retrieves the data frame
   from the \code{summary_desc}
   slot of a given \code{flowGraph} object.
   See \code{\link[flowGraph]{fg_get_summary_desc}}.}
  \item{\code{fg_add_feature}: Adds a feature to a given
   \code{flowGraph} object;
   we do not recommend users directly use this method, instead please use
   wrapper functions e.g. \code{\link[flowGraph]{fg_feat_node_prop}},
   \code{\link[flowGraph]{fg_feat_node_specenr}},
   See \code{\link[flowGraph]{fg_add_feature}}.}
  \item{\code{fg_rm_feature}: Removes a user specified feature
   from a given flowGraph object.
   See \code{\link[flowGraph]{fg_rm_feature}}.}
  \item{\code{fg_add_summary}: Adds a feature to a given \code{flowGraph}
   object;
   we do not recommend users directly use this method, instead please use
   wrapper function \code{\link[flowGraph]{fg_summary}}.}
  \item{\code{fg_clear_summary}: Removes all feature summaries
   from a given flowGraph object.
   See \code{\link[flowGraph]{fg_clear_summary}}.}
  \item{\code{fg_rm_summary}: Removes a user specified feature summaries
   from a given flowGraph object.
   See \code{\link[flowGraph]{fg_rm_summary}}.}
  \item{\code{fg_gsub_markers}:
   Substitutes marker names in a given \code{flowGraph} object.
   See \code{\link[flowGraph]{fg_gsub_markers}}.}
  \item{\code{fg_gsub_ids}: substitutes sample id's in a \code{flowGraph}
   object
   See \code{\link[flowGraph]{fg_gsub_ids}}.}
  \item{\code{fg_merge_samples}: Merges the samples of two \code{flowGraph}
   objects;
   we recomment users use the wrapper function
    \code{\link[flowGraph]{fg_merge}} instead.
   See \code{\link[flowGraph]{fg_merge_samples}}.}
  \item{\code{fg_extract_samples}: Extract data for specific samples
   from a flowGraph object.
   See \code{\link[flowGraph]{fg_extract_samples}}.}
  \item{\code{fg_extract_phenotypes}: Extract data for specific
   cell population nodes from a \code{flowGraph} object.
   See \code{\link[flowGraph]{fg_extract_phenotypes}}.}
  \item{\code{fg_merge}: Merges two given \code{flowGraph} objects.
   See \code{\link[flowGraph]{fg_merge}}.}
  \item{\code{fg_set_layout}: Sets layout for cell population nodes
   for the purpose of plotting.
   See \code{\link[flowGraph]{fg_set_layout}}.}
   \item{\code{fg_plot}: Plots cell hierarchies in the flowGraph object.
   See \code{\link[flowGraph]{fg_plot}}.}
}
}

\examples{

 showClass("flowGraph")
}
