% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_flowgraph_modifiers.R
\name{fg_add_summary}
\alias{fg_add_summary}
\title{Adds a feature summary.}
\usage{
fg_add_summary(
  fg,
  type = "node",
  summary_meta = NULL,
  p = NULL,
  summ_fun = NULL,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{fg}{flowGraph object.}

\item{type}{A string indicating feature type the summary was created for;
'node' or 'edge'.}

\item{summary_meta}{The user must provide \code{type} and
 \code{summary_meta}.

 \code{summary_meta} is a list containing
 \code{feature} (feature name), \code{test_name} (summary statistic name),
 \code{class} (class), \code{label1}, and \code{label2} (class labels compared).
 See \code{\link[flowGraph]{fg_get_summary_desc}} for details.}

\item{p}{A list containing summary values; this list contains elements:
\code{values} (a vector containing summary statistics e.g. p-values;
 this vector should be named by their associated phenotype or edge name),
\code{test_custom} (a function of the statistical test used), and
\code{adjust_custom} (a function of the p-value correction method used).
This list must contain the \code{values} element.}

\item{summ_fun}{A function that ouputs a feature summary matrix
as in \code{p} given \code{fg} and other optional parameters.}

\item{overwrite}{A logical variable indicating whether or not the function
should replace the existing feature summary with the
same name if one is already in \code{fg}.}

\item{...}{Other parameters that would be used as input into \code{summ_fun}.}
}
\value{
flowGraph object.
}
\description{
Adds a feature summary into a given flowGraph object.
 Only use this function if your summary statistic cannot be calcuated
 using the \code{\link[flowGraph]{fg_summary}} function.
}
\details{
\code{fg_add_summary} adds the given feature summary list \code{p}
 or the output of the given function \code{summ_fun} to the
 given flowGraph object \code{fg} updating slots
 \code{summary} and \code{summary_desc}.
 See \code{\link[flowGraph]{flowGraph-class}}
 slot \code{summary} and \code{summary_desc}
 for what should be in these slots. We do not recommend users directly use
 this function unless what is required is duly in the above slots is
 well understood --- note these slots are used in plotting functions
 e.g. \code{\link[flowGraph]{fg_plot}}. We instead recommend users to use
 the \code{\link[flowGraph]{fg_summary}} function.
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 no_cores=no_cores)

 # get samples that we are going to compare
 m <- fg_get_feature(fg, type="node", feature="prop")
 m1_ <- m[fg_data_pos30$meta$class=="control",,drop=FALSE]
 m2_ <- m[fg_data_pos30$meta$class=="exp",,drop=FALSE]

 # define test or summary function to conduct comparison
 test_custom <- function(x,y)
     tryCatch(stats::t.test(x,y)$p.value, error=function(e) 1)
 values_p <- sapply(seq_len(ncol(m)), function(j)
     test_custom(m1_[,j], m2_[,j]) )
 values_p <- p.adjust(values_p , method="BY")

 # the user can choose to fill either parameter "p" or "summ_fun",
 # the latter of which must output a list with the same elements as "p".
 # see documentation for ?flowGraph-class, slot "summary" for
 # details on what should be in "p".
 p <- list(values=values_p, test_fun=test_custom, adjust_fun="BY")
 fg <- fg_add_summary(fg, type="node", summary_meta=list(
      feature="prop", test_name="wilcox_BY",
      class="class", label1="control", label2="exp"), p=p)

 fg_get_summary_desc(fg)


}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_summary}}
 \code{\link[flowGraph]{fg_get_summary}}
 \code{\link[flowGraph]{fg_rm_summary}}
 \code{\link[flowGraph]{fg_get_summary_desc}}
 \code{\link[flowGraph]{fg_add_feature}}
}
