% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_gate_transform_interactive.R
\name{gs_gate_transform_interactive}
\alias{gs_gate_transform_interactive}
\title{Interactively adjust a gate from a GatingSet}
\usage{
gs_gate_transform_interactive(
  gs,
  node,
  sample = 1,
  dims = list("FSC-A", "SSC-A"),
  overlayGates = NULL
)
}
\arguments{
\item{gs}{The GatingSet containing the gate you want to adjust}

\item{node}{String specifying the (unambiguous) name of the node to adjust}

\item{sample}{Numeric specifying which sample in the GatingSet to use for
example purposes. Note that the adjusted gate will be applied to ALL
samples, not just this one.}

\item{dims}{List of characters specifying channel names or marker names to
plot on x and y axis. Defaults to list("FSC-A", "SSC-A") mostly just to
make the format clear.}

\item{overlayGates}{(optional) string or character vector specifying names of
gates to draw on the plot but NOT adjust, for ease of adjusting a gate in
the vicinity of other gates. Leave NULL to not overlay any gates.}
}
\value{
NULL, but silently deletes the old gate, adds the new one, and
  recomputes the GatingSet.
}
\description{
CAUTION: Experimental Function. Still probably has bugs.
}
\details{
Call gs_gate_transform_interactive to open a small Shiny app to allow for
manual, interactive adjustments to gates. Currently only supports
rectangleGates and polygonGates.
}
\examples{
path_to_fcs <- system.file("extdata", package = "flowGate")
fs <- read.flowSet(path = path_to_fcs,
                   pattern = ".FCS$",
                   full.names = TRUE)
gs <- GatingSet(fs)

if(interactive()) { # only run in interactive sessions
gs_gate_interactive(gs,
                    filterId = "Lymphocytes",
                    dims = list("FSC-H", "SSC-H"))
                    
# Adds a lymphocytes gate to the GatingSet (exactly as in gs_gate_interactive)
                    
gs_gate_transform_interactive(gs,
                              filterId = "Lymphocytes", 
                              dims = list("FSC-H", "SSC-H"))
}

# Opens a window to adjust the gate manually

}
