% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeFilter-methods.R
\docType{methods}
\name{summarizeFilter-methods}
\alias{summarizeFilter-methods}
\alias{summarizeFilter}
\alias{summarizeFilter,filterResult,filter-method}
\alias{summarizeFilter,filterResult,filterReference-method}
\alias{summarizeFilter,filterResult,parameterFilter-method}
\alias{summarizeFilter,filterResult,subsetFilter-method}
\alias{summarizeFilter,logicalFilterResult,norm2Filter-method}
\alias{summarizeFilter,logicalFilterResult,parameterFilter-method}
\alias{summarizeFilter,multipleFilterResult,parameterFilter-method}
\title{Methods for function summarizeFilter}
\usage{
summarizeFilter(result, filter)
}
\arguments{
\item{result}{A \code{\linkS4class{filterResult}} (or one of its derived classes)
representing the result of a filtering operation in whose 
\code{filterDetails} slot the information will be stored.}

\item{filter}{The corresponding \code{\linkS4class{filter}} (or one of its
derived classes).}
}
\description{
Internal methods to populate the \code{filterDetails} slot of a
\code{\link{filterResult}} object.
}
\section{Methods}{
 
\describe{

\item{summarizeFilter(result = "filterResult", filter = "filter")}{ \code{summarizeFilter}
methods are called during the process of filtering. Their output is a list,
and it can be arbitrary data that should be stored along with the results of
a filtering operation. }

\item{summarizeFilter(result = "filterResult", filter = "filterReference")}{ see above }

\item{summarizeFilter(result = "filterResult", filter = "parameterFilter")}{ see above }

\item{summarizeFilter(result = "filterResult", filter = "subsetFilter")}{ see above }

\item{summarizeFilter(result = "logicalFilterResult", filter = "norm2Filter")}{ see above }

\item{summarizeFilter(result = "logicalFilterResult", filter = "parameterFilter")}{ see above
}

\item{summarizeFilter(result = "multipleFilterResult", filter = "parameterFilter")}{ see
above } }
}

\keyword{methods}
