% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{ratio-class}
\alias{ratio-class}
\alias{ratio}
\alias{eval,ratio,missing-method}
\alias{initialize,ratio-method}
\title{Class "ratio"}
\description{
ratio transform calculates the ratio of two parameters defined by the
function \deqn{f(parameter_1,parameter_2)=\frac{parameter_1}{parameter_2}}
}
\section{Slots}{

\describe{
\item{\code{.Data}}{Object of class \code{"function"}.}

\item{\code{numerator}}{Object of class \code{"transformation"} -- flow parameter
to be transformed}

\item{\code{denominator}}{Object of class \code{"transformation"} -- flow parameter
to be transformed.}

\item{\code{transformationId}}{Object of class \code{"character"} -- unique ID to
reference the transformation.}
}}

\note{
The ratio transformation object can be evaluated using the eval method
by passing the data frame as an argument.The transformed parameters are
returned as matrix with one column. (See example below)
}
\section{Objects from the Class}{
 Objects can be created by calls to the
constructor \code{ratio(parameter1,parameter2,transformationId) }.
}

\section{Extends}{

Class \code{"\linkS4class{transform}"}, directly.

Class \code{"\linkS4class{transformation}"}, by class "transform", distance 2.

Class \code{"\linkS4class{characterOrTransformation}"}, by class "transform", distance 3.
}

\examples{

  dat <- read.FCS(system.file("extdata","0877408774.B08",
  package="flowCore"))
  rat1<-ratio("FSC-H","SSC-H",transformationId="rat1")
  transOut<-eval(rat1)(exprs(dat))

}
\references{
Gating-ML Candidate Recommendation for Gating Description in
Flow Cytometry V 1.5
}
\seealso{
dg1polynomial,quadratic,squareroot

Other mathematical transform classes: 
\code{\link{EHtrans-class}},
\code{\link{asinht-class}},
\code{\link{asinhtGml2-class}},
\code{\link{dg1polynomial-class}},
\code{\link{exponential-class}},
\code{\link{hyperlog-class}},
\code{\link{hyperlogtGml2-class}},
\code{\link{invsplitscale-class}},
\code{\link{lintGml2-class}},
\code{\link{logarithm-class}},
\code{\link{logicletGml2-class}},
\code{\link{logtGml2-class}},
\code{\link{quadratic-class}},
\code{\link{ratiotGml2-class}},
\code{\link{sinht-class}},
\code{\link{splitscale-class}},
\code{\link{squareroot-class}},
\code{\link{unitytransform-class}}
}
\author{
Gopalakrishnan N, F.Hahne
}
\concept{mathematical transform classes}
\keyword{classes}
