% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotEnrichmentData}
\alias{plotEnrichmentData}
\title{Returns data required for doing an enrichment plot.}
\usage{
plotEnrichmentData(pathway, stats, gseaParam = 1)
}
\arguments{
\item{pathway}{Gene set to plot.}

\item{stats}{Gene-level statistics.}

\item{gseaParam}{GSEA parameter.}
}
\value{
returns list with the following data:
* `curve` - data.table with the coordinates of the enrichment curve;
* `ticks` - data.table with statistic entries for each pathway gene,adjusted with gseaParam;
* `stats` - data.table with statistic values for all of the genes, adjusted with gseaParam;
* `posES`, `negES`, `spreadES` - values of the positive enrichment score,
 negative enrichment score, and difference between them;
* `maxAbsStat` - maximal absolute value of statistic entries, adjusted with gseaParam
}
\description{
Returns data required for doing an enrichment plot.
}
\examples{
library(ggplot2)
data(examplePathways)
data(exampleRanks)

pd <- plotEnrichmentData(
    pathway = examplePathways[["5991130_Programmed_Cell_Death"]],
    stats = exampleRanks
)

with(pd,
     ggplot(data=curve) +
         geom_line(aes(x=rank, y=ES), color="green") +
         geom_ribbon(data=stats,
                     mapping=aes(x=rank, ymin=0,
                                 ymax=stat/maxAbsStat*(spreadES/4)),
                     fill="grey") +
         geom_segment(data=ticks,
                      mapping=aes(x=rank, y=-spreadES/16,
                                  xend=rank, yend=spreadES/16),
                      size=0.2) +
         geom_hline(yintercept=posES, colour="red", linetype="dashed") +
         geom_hline(yintercept=negES, colour="red", linetype="dashed") +
         geom_hline(yintercept=0, colour="black") +
         theme(
             panel.background = element_blank(),
             panel.grid.major=element_line(color="grey92")
         ) +
         labs(x="rank", y="enrichment score"))
}
