% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome.R
\name{fetch_reactome}
\alias{fetch_reactome}
\title{Get functional term data from Reactome}
\usage{
fetch_reactome(
  species,
  source = c("ensembl", "api", "gene_association"),
  use_cache = TRUE,
  on_error = c("stop", "warn", "ignore")
)
}
\arguments{
\item{species}{Reactome species designation, for example "Homo sapiens" for
human. Full list of available species can be found using
\code{fetch_reactome_species()}.}

\item{source}{How to download the mapping. If 'ensembl' or
'gene_association', one mapping file provided by Reactome will be
downloaded, if 'api', then Reactome API will be used. See details.}

\item{use_cache}{Logical, if TRUE, the remote file will be cached locally.}

\item{on_error}{A character string indicating the error handling strategy:
either "stop" to halt execution, "warn" to issue a warning and return
`NULL` or "ignore" to return `NULL` without warnings. Defaults to "stop".}
}
\value{
A list with \code{terms} and \code{mapping} tibbles
}
\description{
Download term information (pathway ID and name) and gene-pathway mapping
(Ensembl gene ID or gene symbol and pathway ID) from Reactome.
}
\details{
Reactome makes mapping between Ensembl ID and pathway ID available
  in form of one downloadable file. This mapping contains gene symbols as
  well. Also, a gene association file with mapping between UniProt accession
  number, gene symbol and Reactome term is available. If \code{source =
  "ensembl"} or \code{source =
  "gene_association"} is set, one large file will be downloaded and parsed.
  If \code{source = "api"} is set, then Reactome APIs will be interrogated
  for each pathway available. This method is considerably slower, especially
  for large genomes. However, gene association file contains far fewer
  mappings than can be extracted using API. If gene symbols are needed, we
  recommend using  \code{source = "ensembl"}.
}
\examples{
reactome_data <- fetch_reactome("Saccharomyces cerevisiae", on_error = "warn")
}
