% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/available.R
\name{faers_available}
\alias{faers_available}
\title{Check if FAERS year}
\usage{
faers_available(years, quarters, force = FALSE, internal = FALSE)
}
\arguments{
\item{years}{An atomic integer indicates years for which data are required.}

\item{quarters}{An atomic character, only "q1", "q2", "q3", and "q4" are
allowed.}

\item{force}{A boolean value. If set to \code{TRUE}, it indicates the retrieval of
information about all records' metadata in the FAERS Quarterly Data Extract
Files Site, bypassing the cache.}

\item{internal}{A boolean value. It determines whether to use the internal
data associated with the package.}
}
\value{
A logical indicates FAERS can have data for the \code{years} and
\code{quarters} required?
}
\description{
This function check if data for the years and quarters selected are
available at FAERS to be downloaded.
}
\examples{
faers_available(c(2011, 2023), c("q1", "q2"))
}
