% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotOverlaps.R
\name{plotOverlaps}
\alias{plotOverlaps}
\alias{plotOverlaps,GRangesList-method}
\alias{plotOverlaps,list-method}
\title{Plot Overlaps Between List Elements}
\usage{
plotOverlaps(x, ...)

\S4method{plotOverlaps}{GRangesList}(
  x,
  type = c("auto", "venn", "upset"),
  var = NULL,
  f = c("mean", "median", "max", "min", "sd"),
  merge_within = 1L,
  ignore.strand = TRUE,
  set_col = NULL,
  ...,
  label_size = 3.5,
  hj_sets = 1.15,
  exp_sets = 0.2,
  vj_intersect = -0.5,
  exp_intersect = 0.1
)

\S4method{plotOverlaps}{list}(
  x,
  type = c("auto", "venn", "upset"),
  set_col = NULL,
  ...,
  label_size = 3.5,
  hj_sets = 1.15,
  exp_sets = 0.2,
  vj_intersect = -0.5,
  exp_intersect = 0.1
)
}
\arguments{
\item{x}{GRangesList of S3 list able to be coerced to character vectors}

\item{...}{Passed to \link[VennDiagram]{draw.pairwise.venn} (or
\code{draw.single/triple.venn}) for Venn Diagrams, and to
\link[SimpleUpset]{simpleUpSet} for UpSet plots}

\item{type}{The type of plot to be produced}

\item{var}{Column to summarised as a boxplot in an upper panel
(UpSet plot only)}

\item{f}{Summarisation function. Must return a single value from any
numeric vector}

\item{merge_within}{Passed to \link{makeConsensus}}

\item{ignore.strand}{Passed to \link[GenomicRanges]{reduce}}

\item{set_col}{Colours to be assigned to each set}

\item{label_size}{Text size for set and intersection labels. Passed
internally to \code{geom_text(size = label_size)}}

\item{hj_sets}{Horizontal adjustment of set size labels}

\item{exp_sets}{X-axis expansion for set size panel}

\item{vj_intersect}{Vertical adjustment of intersection size labels}

\item{exp_intersect}{Y-axis expansion for intersections size panel}
}
\value{
Either a VennDiagram (i.e. grid) object, or a ComplexUpset plot
}
\description{
Plot Overlaps between list elements as an upset or Venn diagram
}
\details{
This function should give the capability to show overlaps for any number of
replicates or groups, or a list of items such as gene names.
For n = 2, a scaled Venn Diagram will be produced, however no scaling is
implemented for n = 3

UpSet plots are possible for any lists with length > 1, and are the only
implemented possibility for lists > 3.

If the input is a \code{GRangesList} an additional boxplot can be requested
using any numeric column within the existing \code{mcols()} element.
Values will be summarised across all elements using the requested function
and the boxplot will be included as an upper panel above the intersections
}
\examples{
## Examples using a list of character vectors
ex <- list(
  x = letters[1:5], y = letters[c(6:15, 26)], z = letters[c(2, 10:25)]
)
plotOverlaps(ex, type = "upset")
plotOverlaps(ex, type = "venn", set_col = 1:3, alpha = 0.3)
plotOverlaps(ex[1:2])

## GRangesList object will produce a boxplot of summarised values in the
## upper panel
data("peaks")
grl <- peaks[1:3]
names(grl) <- gsub("_peaks.+", "", names(grl))
plotOverlaps(grl, type = 'upset', var = 'score', f = 'max')

## If only two samples are present, a VennDiagram will be produced
plotOverlaps(grl[1:2], set_col = c("green", "blue"), cex = 1.5, cat.cex = 1.5)

}
