% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapseGenes.R
\name{collapseGenes}
\alias{collapseGenes}
\title{Collapse a vector of gene names}
\usage{
collapseGenes(
  x,
  sort = TRUE,
  dedup = TRUE,
  format = "_",
  sep = ", ",
  last = " and ",
  numeric = TRUE,
  width = Inf,
  ...
)
}
\arguments{
\item{x}{character vector representing gene names}

\item{sort}{logical(1) Should the names be sorted alphabetically}

\item{dedup}{logical(1) Should duplicate names be removed}

\item{format}{character string for markdown formatting of each element}

\item{sep}{separator between vector elements}

\item{last}{character string to place before the last element}

\item{numeric}{logical(1) sort digits numerically, instead of as strings}

\item{width}{The maximum width of the string before truncating to ...}

\item{...}{passed to \link[stringr]{str_sort}}
}
\value{
a glue object
}
\description{
Collapse a vector of gene names
}
\details{
Convenience function to collapse a vector of gene names into a character/glue
object of length 1. By default, symbols are deduplicated, sorted
alpha-numerically and italicised with an underscore.
}
\examples{
genes <- c("FOXP3", "BRCA1", "TP53")
collapseGenes(genes)

}
