#' @title Dataset: Structural ontology metrics
#' @description
#' Structural ontology metrics, 19 metrics measuring
#' structural aspects of bio-ontologies have been analysed on two different
#' corpora of ontologies: OBO Foundry and AgroPortal
#'
#' @references
#' \insertRef{ontoeval}{evaluomeR}
#' @usage data("ontMetrics")
"ontMetrics"

#' @title Dataset: RNA quality metrics
#' @description
#' RNA quality metrics for the assessment of gene expression
#' differences, 2 quality metrics from 16 aliquots of a unique batch of RNA
#' Samples. The metrics are Degradation Factor (DegFact) and RNA Integrity Number
#' (RIN)
#'
#' @references
#' \insertRef{imbeaud2005towards}{evaluomeR}
#' @usage data("rnaMetrics")
"rnaMetrics"

#' @title Dataset: Metrics for biological pathways
#' @description
#' Metrics for biological pathways, 2 metrics that
#' quantitative characterizations of the importance of regulation in biochemical
#' pathway systems, including systems designed for applications in synthetic
#' biology or metabolic engineering. The metrics are reachability and efficiency
#'
#' @references
#' \insertRef{davis2018metrics}{evaluomeR}
#' @usage data("bioMetrics")
"bioMetrics"
