% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runEscape.R
\name{runEscape}
\alias{runEscape}
\title{Calculate Enrichment Scores Using Seurat or SingleCellExperiment Objects}
\usage{
runEscape(
  input.data,
  gene.sets,
  method = c("ssGSEA", "GSVA", "UCell", "AUCell"),
  groups = 1000,
  min.size = 5,
  normalize = FALSE,
  make.positive = FALSE,
  new.assay.name = "escape",
  min.expr.cells = 0,
  min.filter.by = NULL,
  BPPARAM = NULL,
  ...
)
}
\arguments{
\item{input.data}{A raw‐counts matrix (`genes × cells`), a
\link[SeuratObject]{Seurat} object, or a
\link[SingleCellExperiment]{SingleCellExperiment}. Gene identifiers must
match those in `gene.sets`.}

\item{gene.sets}{A named list of character vectors, the result of
[getGeneSets()], or the built-in data object [escape.gene.sets]. 
List names become column names in the result.}

\item{method}{Scoring algorithm (case-insensitive). One of `"GSVA"`, 
`"ssGSEA"`, `"UCell"`, or `"AUCell"`. Default **`"ssGSEA"`**.}

\item{groups}{Integer >= 1. Number of cells per processing chunk.
Larger values reduce overhead but increase memory usage.  Default **1000**.}

\item{min.size}{Minimum number of genes from a set that must be detected
in the expression matrix for that set to be scored.  Default **5**.
Use `NULL` to disable filtering.}

\item{normalize}{Logical. If `TRUE`, the score matrix is passed to
[performNormalization()] (drop-out scaling and optional log transform).
Default **FALSE**.}

\item{make.positive}{Logical. If `TRUE` *and* `normalize = TRUE`, shifts
every gene-set column so its global minimum is zero, facilitating
downstream log-ratio analyses.  Default **FALSE**.}

\item{new.assay.name}{Character. Name for the assay that will store the
enrichment matrix in the returned object. Default **"escape"**.}

\item{min.expr.cells}{Numeric. Gene-expression filter threshold (see
details above). Default **0** (no gene filtering).}

\item{min.filter.by}{Character or `NULL`.  Column name in `meta.data`
(Seurat) or `colData` (SCE) defining groups within which the
`min.expr.cells` rule is applied.  Default **`NULL`**.}

\item{BPPARAM}{A \pkg{BiocParallel} parameter object describing the
parallel backend.}

\item{...}{Extra arguments passed verbatim to the chosen back-end
scoring function (`gsva()`, `ScoreSignatures_UCell()`, or
`AUCell_calcAUC()`).}
}
\value{
The input single-cell object with an additional assay containing the
enrichment scores (`cells × gene-sets`). Matrix orientation follows
standard single-cell conventions (gene-sets as rows inside the assay).
}
\description{
`runEscape()` is a convenience wrapper around [escape.matrix()] that
computes enrichment scores and inserts them as a new assay (default
`"escape"`) in a \pkg{Seurat} or \pkg{SingleCellExperiment} object.  All
arguments (except `new.assay.name`) map directly to their counterparts in
`escape.matrix()`.
}
\examples{
gs <- list(Bcells = c("MS4A1", "CD79B", "CD79A", "IGH1", "IGH2"),
           Tcells = c("CD3E", "CD3D", "CD3G", "CD7","CD8A"))

sce <- SeuratObject::pbmc_small
sce <- runEscape(sce, 
                 gene.sets = gs, 
                 method = "GSVA",
                 groups = 1000, 
                 min.size = 3,
                 new.assay.name = "escape")

}
\seealso{
[escape.matrix()] for the underlying computation,
[performNormalization()] to add normalized scores, [heatmapEnrichment()], 
[ridgeEnrichment()] and related plotting helpers for visualization.
}
\author{
Nick Borcherding, Jared Andrews
}
