% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performPCA.R
\name{performPCA}
\alias{performPCA}
\title{Perform Principal Component Analysis on Enrichment Data}
\usage{
performPCA(
  input.data,
  assay = "escape",
  scale = TRUE,
  n.dim = 10,
  reduction.name = "escape.PCA",
  reduction.key = "escPC_"
)
}
\arguments{
\item{input.data}{Output of \code{\link{escape.matrix}} or a single‑cell
object previously processed by \code{\link{runEscape}}.}

\item{assay}{Name of the assay holding enrichment scores when
`input.data` is a single‑cell object. Ignored otherwise.}

\item{scale}{Logical; if `TRUE` standardises each gene-set column
before PCA.}

\item{n.dim}{Integer >= 1 or vector; the **largest** value sets the
number of principal components to compute / keep.}

\item{reduction.name, reduction.key}{Names used when writing back to a
Seurat / SCE object.}
}
\value{
*If* `input.data` is a single-cell object, the same object with a
  new dimensional-reduction slot.  *Otherwise* a list with  
  `PCA`, `eigen_values`, `contribution`, and `rotation`.
}
\description{
This function allows users to calculate the principal components 
for the gene set enrichment values. For single-cell data, the PCA
will be stored with the dimensional reductions. If a matrix is used
as input, the output is a list for further plotting. Alternatively,
users can use functions for PCA calculations based on their desired
workflow in lieu of using \code{\link{performPCA}}, but will not be 
compatible with downstream \code{\link{pcaEnrichment}} visualization.
}
\examples{
gs <- list(Bcells = c("MS4A1", "CD79B", "CD79A", "IGH1", "IGH2"),
           Tcells = c("CD3E", "CD3D", "CD3G", "CD7","CD8A"))

pbmc <- SeuratObject::pbmc_small |>
  runEscape(gene.sets = gs,
            min.size = NULL)           
                        
pbmc <- performPCA(pbmc, 
                   assay = "escape")

}
