% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods.R
\name{atacRepsPipe}
\alias{atacRepsPipe}
\title{Pipeline for multi-replicates case paired-end sequencing data}
\usage{
atacRepsPipe(
  genome,
  fastqInput1,
  fastqInput2 = NULL,
  refdir = NULL,
  tmpdir = NULL,
  threads = 2,
  adapter1 = NULL,
  adapter2 = NULL,
  interleave = FALSE,
  createReport = TRUE,
  motifs = NULL,
  prefix = NULL,
  chr = c(1:22, "X", "Y"),
  p.cutoff = 1e-06,
  ...
)
}
\arguments{
\item{genome}{\code{Character} scalar. The genome(like hg19, mm10, etc.) reference data in "refdir" to be used in the pipeline.}

\item{fastqInput1}{\code{List} scalar. For single-end sequencing,
it contains sequence file paths.
For paired-end sequencing, it can be file paths with #1 mates paired
with file paths in fastqInput2
And it can also be interleaved file paths when argument
interleaved=\code{TRUE}.
Each element in the fastqInput1 \code{List} is for a replicate
It can be a \code{Character} vector of FASTQ files paths to be merged.}

\item{fastqInput2}{\code{List} scalar. It contains file paths with #2
mates paired with file paths in fastqInput1.
For single-end sequencing files and interleaved paired-end sequencing
files(argument interleaved=\code{TRUE}),
it must be \code{NULL}.
Each element in the fastqInput1 \code{List} is for a replicate
It can be a \code{Character} vector of FASTQ files paths to be merged.}

\item{refdir}{\code{Character} scalar. The path for reference data being installed to and storage.}

\item{tmpdir}{\code{Character} scalar. The temporary file storage path.}

\item{threads}{\code{Integer} scalar. The max threads allowed to be created.}

\item{adapter1}{\code{Character} scalar. It is an adapter sequence for file1.
For single end data, it is requied.}

\item{adapter2}{\code{Character} scalar. It is an adapter sequence for file2.}

\item{interleave}{\code{Logical} scalar. Set \code{TRUE} when files are
interleaved paired-end sequencing data.}

\item{createReport}{\code{Logical} scalar. If the HTML report file will be created.}

\item{motifs}{either\code{\link{PFMatrix}}, \code{\link{PFMatrixList}},
\code{\link{PWMatrix}}, \code{\link{PWMatrixList}}, default: vertebrates motif from JASPAR.}

\item{prefix}{\code{Character} scalar. Temporary file prefix for identifying files
when multiple pipeline generating file in the same tempdir.}

\item{chr}{Which chromatin the program will processing. It must be identical
with the filename of cut site information files or subset of .
Default:c(1:22, "X", "Y").}

\item{p.cutoff}{p-value cutoff for returning motifs, default: 1e-6.}

\item{...}{Additional arguments, currently unused.}
}
\value{
\code{List} scalar. It is a list that save the result of the pipeline.
Slot "filelist": the input file paths.
Slot "wholesummary": a dataframe that for quality control summary
Slot "atacProcs": \code{\link{ATACProc-class}} objects generated by each process in the pipeline.
Slot "filtstat": a dataframe that summary the reads filted in each process.
}
\description{
The preset pipeline to process multi-replicates case study sequencing data.
HTML report files, result files(e.g. BED, BAM files) and
conclusion list will generated. See detail for usage.
}
\examples{
\dontrun{
## These codes are time consuming so they will not be run and
## checked by bioconductor checker.


# call pipeline
# for a quick example(only CTCF and BATF3 will be processing)
conclusion <-
  atacRepsPipe(
       # MODIFY: Change these paths to your own case files!
       # e.g. fastqInput1 = "your/own/data/path.fastq"
       fastqInput1 = list(system.file(package="esATAC", "extdata", "chr20_1.1.fq.gz"),
                          system.file(package="esATAC", "extdata", "chr20_1.2.fq.bz2")),
       fastqInput2 = list(system.file(package="esATAC", "extdata", "chr20_2.1.fq.gz"),
                          system.file(package="esATAC", "extdata", "chr20_2.2.fq.bz2")),
       # MODIFY: Set the genome for your data
       genome = "hg19",
       motifs = getMotifInfo(motif.file = system.file("extdata", "CustomizedMotif.txt", package="esATAC")))

# call pipeline
# for overall example(all vertebrates motif in JASPAR will be processed)
conclusion <-
  atacRepsPipe(
       # MODIFY: Change these paths to your own case files!
       # e.g. fastqInput1 = "your/own/data/path.fastq"
       fastqInput1 = list(system.file(package="esATAC", "extdata", "chr20_1.1.fq.gz"),
                          system.file(package="esATAC", "extdata", "chr20_1.2.fq.bz2")),
       fastqInput2 = list(system.file(package="esATAC", "extdata", "chr20_2.1.fq.gz"),
                          system.file(package="esATAC", "extdata", "chr20_2.2.fq.bz2")),
       # MODIFY: Set the genome for your data
       genome = "hg19")
}
}
\seealso{
\code{\link{printMap}},
\code{\link{atacPipe2}},
\code{\link{atacRenamer}},
\code{\link{atacRemoveAdapter}},
\code{\link{atacBowtie2Mapping}},
\code{\link{atacPeakCalling}},
\code{\link{atacMotifScan}}
}
\author{
Zheng Wei and Wei Zhang
}
