% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindAdapter.R
\name{FindAdapter}
\alias{FindAdapter}
\alias{atacFindAdapter,ATACProc-method}
\alias{atacFindAdapter}
\alias{findAdapter}
\title{Use AdapterRemoval to identify adapters}
\usage{
atacFindAdapter(
  atacProc,
  fastqInput1 = NULL,
  fastqInput2 = NULL,
  reportPrefix = NULL,
  interleave = FALSE,
  findParamList = NULL,
  threads = getThreads(),
  ...
)

\S4method{atacFindAdapter}{ATACProc}(
  atacProc,
  fastqInput1 = NULL,
  fastqInput2 = NULL,
  reportPrefix = NULL,
  interleave = FALSE,
  findParamList = NULL,
  threads = getThreads(),
  ...
)

findAdapter(
  fastqInput1,
  fastqInput2 = NULL,
  reportPrefix = NULL,
  interleave = FALSE,
  findParamList = NULL,
  threads = getThreads(),
  ...
)
}
\arguments{
\item{atacProc}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacRenamer}}
\code{\link{renamer}}
\code{\link{atacUnzipAndMerge}}
\code{\link{unzipAndMerge}}}

\item{fastqInput1}{\code{Character} vector. For single-end sequencing,
it contains sequence file paths.
For paired-end sequencing, it can be file paths with #1 mates paired
with file paths in fastqInput2
And it can also be interleaved file paths when argument
interleaved=\code{TRUE}}

\item{fastqInput2}{\code{Character} vector. It contains file paths with #2
mates paired with file paths in fastqInput1
For single-end sequencing files and interleaved paired-end sequencing
files(argument interleaved=\code{TRUE}),
it must be \code{NULL}.}

\item{reportPrefix}{\code{Character}. The prefix of report files path.
Default: generate from known parameters}

\item{interleave}{\code{Logical}. Set \code{TRUE} when files are
interleaved paired-end sequencing data.}

\item{findParamList}{Additional arguments to be passed on to the binaries
for identifying adapter. See below for details.}

\item{threads}{The number of threads used in this step.}

\item{...}{Additional arguments, currently unused.}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar for downstream analysis.
}
\description{
Use AdapterRemoval to identify adapters for paired end data
}
\details{
The parameter related to input and output file path
will be automatically
obtained from \code{\link{ATACProc-class}} object or
generated based on known parameters
if their values are default(e.g. \code{NULL}).
Otherwise, the generated values will be overwrited.
If you want to use this function independently,
you can use \code{findAdapter} instead.
You can put all aditional
arguments in one \code{Character}(e.g. "--threads 8") with white space
splited just like command line,
or put them in \code{Character} vector(e.g. c("--threads","8")).
Note that some arguments(
"--file1","--file2","--adapter1","--adapter2","--output1","--output2",
"--basename","--interleaved","thread") to the
findParamList are invalid if they are already handled as explicit
function arguments. See the output of
\code{adapterremoval_usage()} for details about available parameters.
}
\examples{
library(magrittr)
td <- tempdir()
setTmpDir(td)

# Identify adapters
prefix<-system.file(package="esATAC", "extdata", "uzmg")
(reads_1 <-file.path(prefix,"m1",dir(file.path(prefix,"m1"))))
(reads_2 <-file.path(prefix,"m2",dir(file.path(prefix,"m2"))))

reads_merged_1 <- file.path(td,"reads1.fastq")
reads_merged_2 <- file.path(td,"reads2.fastq")
atacproc <-
atacUnzipAndMerge(fastqInput1 = reads_1,fastqInput2 = reads_2) \%>\%
atacRenamer \%>\% atacFindAdapter

dir(td)
}
\seealso{
\code{\link{atacRenamer}}
\code{\link{renamer}}
\code{\link{atacUnzipAndMerge}}
\code{\link{unzipAndMerge}}
\code{\link{atacBowtie2Mapping}}
}
\author{
Zheng Wei
}
