% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CutSitePre.R
\name{CutSitePre}
\alias{CutSitePre}
\alias{atacExtractCutSite,ATACProc-method}
\alias{atacExtractCutSite}
\alias{extractcutsite}
\title{Extract ATAC-seq cutting site from bed file.}
\usage{
atacExtractCutSite(
  atacProc,
  bedInput = NULL,
  csOutput.dir = NULL,
  prefix = NULL,
  ...
)

\S4method{atacExtractCutSite}{ATACProc}(
  atacProc,
  bedInput = NULL,
  csOutput.dir = NULL,
  prefix = NULL,
  ...
)

extractcutsite(bedInput, csOutput.dir = NULL, prefix = NULL, ...)
}
\arguments{
\item{atacProc}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacSamToBed}}.}

\item{bedInput}{\code{Character} scalar.
Input bed file path, must be merged bed file(a line is a fragment). The
input file should be UCSC bed format(0-based).}

\item{csOutput.dir}{\code{Character} scalar.
The output path, an empty folder would be great. Default: a folder in the
same path as input bed file.}

\item{prefix}{\code{Character} scalar.
Output file name prefix, e.g. prefix_chr*.bed, default "Cutsite".}

\item{...}{Additional arguments, currently unused.}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar for downstream
analysis.
}
\description{
Extract cutting site from ATAC-seq fangment bed file
(from \code{\link{atacSamToBed}}).
}
\details{
In ATAC-seq data, every line in merged bed file
(from \code{\link{atacSamToBed}}, the first 3 column is chr, start, end)
means a DNA fragment, the cutting site is start+1 and end, this function
extract and sort this information for the next step
(\code{\link{atacCutSiteCount}}).
}
\examples{

library(R.utils)
fra_path <- system.file("extdata", "chr20.50000.bed.bz2", package="esATAC")
frag <- as.vector(bunzip2(filename = fra_path,
destname = file.path(getwd(), "chr20.50000.bed"),
ext="bz2", FUN=bzfile, overwrite=TRUE, remove = FALSE))
extractcutsite(bedInput = frag, prefix = "ATAC")

}
\seealso{
\code{\link{atacCutSiteCount}}
}
\author{
Wei Zhang
}
