% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BedToBigWig.R
\name{BedToBigWig}
\alias{BedToBigWig}
\alias{atacBedToBigWig,ATACProc-method}
\alias{atacBedToBigWig}
\alias{bedToBigWig}
\title{generate BigWig file from BED file}
\usage{
atacBedToBigWig(
  atacProc,
  bedInput = NULL,
  bsgenome = NULL,
  bwOutput = NULL,
  toWig = FALSE,
  ...
)

\S4method{atacBedToBigWig}{ATACProc}(
  atacProc,
  bedInput = NULL,
  bsgenome = NULL,
  bwOutput = NULL,
  toWig = FALSE,
  ...
)

bedToBigWig(bedInput, bsgenome = NULL, bwOutput = NULL, toWig = FALSE, ...)
}
\arguments{
\item{atacProc}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacSamToBed}},
\code{\link{atacBedUtils}}.}

\item{bedInput}{\code{Character} scalar.
Bed file input path.}

\item{bsgenome}{\code{BSGenome} object scalar.
BSGenome object for specific species.}

\item{bwOutput}{\code{Character} scalar.
BigWig file output path.}

\item{toWig}{\code{Logical} scalar.}

\item{...}{Additional arguments, currently unused.
Save as wig file instead of binary BigWig file}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar for downstream analysis.
}
\description{
This function is used to generate BigWig file
from BED reads file.
The BigWig file can be shown reads coverage on genome browser.
}
\details{
The parameter related to input and output file path
will be automatically
obtained from \code{\link{ATACProc-class}} object(\code{atacProc}) or
generated based on known parameters
if their values are default(e.g. \code{NULL}).
Otherwise, the generated values will be overwrited.
If you want to use this function independently,
you can use \code{bedToBigWig} instead.
}
\examples{
library(R.utils)
td <- tempdir()
setTmpDir(td)

bedbzfile <- system.file(package="esATAC", "extdata", "chr20.50000.bed.bz2")
bedfile <- file.path(td,"chr20.50000.bed")
\dontrun{
bunzip2(bedbzfile,destname=bedfile,overwrite=TRUE,remove=FALSE)

library(BSgenome.Hsapiens.UCSC.hg19)
bedToBigWig(bedfile, BSgenome.Hsapiens.UCSC.hg19)

dir(td)
}
}
\seealso{
\code{\link{atacSamToBed}}
\code{\link{samToBed}}
\code{\link{atacBedUtils}}
\code{\link{bedUtils}}
}
\author{
Zheng Wei
}
