% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_r_m.R
\name{est_r_m}
\alias{est_r_m}
\title{Estimate the mRNA fraction differences for the pair of samples using 
replicate data}
\usage{
est_r_m(exDat)
}
\arguments{
\item{exDat}{list, contains input data and stores analysis results}
}
\description{
Estimate the mRNA fraction differences for the pair of samples using 
replicate data
}
\details{
This is the first function to run after an exDat structure is initialized
using initDat, because it is needed for all additional analysis. An r_m of
1 indicates that the two sample types under comparison have 
similar mRNA fractions of total RNA. The r_m estimate is used to adjusted 
the expected ERCC mixture ratios in this analysis and may indicate a need for
a different sample normalization approach.
}
\examples{
data(SEQC.Example)

exDat <- initDat(datType="count", isNorm = FALSE, exTable=MET.CTL.countDat, 
                 filenameRoot = "testRun",sample1Name = "MET",
                 sample2Name = "CTL", erccmix = "RatioPair", 
                 erccdilution = 1/100, spikeVol = 1, totalRNAmass = 0.500,
                 choseFDR = 0.1)

exDat <- est_r_m(exDat)

}
