% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynRangePlot.R
\name{dynRangePlot}
\alias{dynRangePlot}
\title{Produce signal-abundance plot to evaluate dynamic range}
\usage{
dynRangePlot(exDat, allPoints, labelReps)
}
\arguments{
\item{exDat}{list, contains input data and stores analysis results}

\item{allPoints}{boolean, default is false, means of replicates will be 
plotted. If true then all replicates will be plotted as
individual points.}

\item{labelReps}{boolean, default is false. If true then replicates will be
labeled.}
}
\description{
Produce signal-abundance plot to evaluate dynamic range
}
\examples{
data(SEQC.Example)

exDat <- initDat(datType="count", isNorm=FALSE, exTable=MET.CTL.countDat, 
                 filenameRoot="testRun", sample1Name="MET", 
                 sample2Name="CTL", erccmix="RatioPair", 
                 erccdilution=1/100, spikeVol=1, totalRNAmass=0.500,
                 choseFDR=0.1)
                 
exDat <- est_r_m(exDat)
                  
exDat <- dynRangePlot(exDat, allPoints="FALSE", labelReps ="FALSE")

exDat$Figures$dynRangePlot

}
