% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotLODR.R
\name{annotLODR}
\alias{annotLODR}
\title{Annotate signal-abundance and ratio-abundance plots with LODR}
\usage{
annotLODR(exDat)
}
\arguments{
\item{exDat}{list, contains input data and stores analysis results}
}
\description{
Annotate signal-abundance and ratio-abundance plots with LODR
}
\examples{
data(SEQC.Example)
 
exDat <- initDat(datType="array", isNorm=FALSE, 
                 exTable=UHRR.HBRR.arrayDat,
                 filenameRoot="testRun", sample1Name="UHRR",
                 sample2Name="HBRR", erccmix="RatioPair", 
                 erccdilution = 1, spikeVol = 50, 
                 totalRNAmass = 2.5*10^(3), choseFDR=0.01)
                 
exDat <- est_r_m(exDat)
                  
exDat <- dynRangePlot(exDat)

exDat <- geneExprTest(exDat)
\donttest{
exDat <- estLODR(exDat, kind="ERCC", prob=0.9)

exDat <- annotLODR(exDat)

exDat$Figures$maPlot
}
}
