% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util-inits.R
\name{epivizNav}
\alias{epivizNav}
\title{Initialize an \code{\link{EpivizNavigation}} object to visualize in viewer or knit to HTML.}
\usage{
epivizNav(
  chr = NULL,
  start = NULL,
  end = NULL,
  parent = NULL,
  interactive = FALSE,
  ...
)
}
\arguments{
\item{chr}{The chromosome to filter on, e.g., chr="chr11".}

\item{start}{The start location, e.g., start=99800000.}

\item{end}{The end location, e.g., end=130383180.}

\item{parent}{An object of class \verb{[EpivizEnvironment}] or \code{\link{EpivizNavigation}} to append the chart within.}

\item{interactive}{(logical) enable if running a websocket/shiny server}

\item{...}{Additional arguments for initializing navigation, e.g., gene and geneInRange.}
}
\value{
An object of class \code{\link{EpivizNavigation}}.
}
\description{
Initialize an \code{\link{EpivizNavigation}} object to visualize in viewer or knit to HTML.
}
\examples{
epiviz <- epivizNav(chr="chr11", start=99800000, end=103383180)

}
