% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotStackProfile.R
\name{plotStackProfile}
\alias{plotStackProfile}
\title{plotStackProfile()}
\usage{
plotStackProfile(
  rse,
  assay = NULL,
  x_labels = c("Before", "Anchor", "After"),
  title = "",
  zlim = NULL,
  palette = function(n) grDevices::hcl.colors(n, rev = TRUE),
  target_height = 650,
  summary_func = function(x) mean(x, na.rm = TRUE),
  n_core = 1,
  pattern = NULL
)
}
\arguments{
\item{rse}{a RangedSummarizedExperiment input. Aletrnatively: can be a
GRanges object
(for backward compatibility, \code{pattern} will be required).}

\item{assay}{specify the name of the assay to plot,
that should match one of \code{assayNames(rse)}.}

\item{x_labels}{a character vectors of length 3 used to label the x-axis.}

\item{title}{The title of the heatmap}

\item{zlim}{The minimum and maximum z values to match color to values.
Format: zlim = c (min, max)}

\item{palette}{a palette of color,
(i.e. a function of parameter n that should retrun n colors).}

\item{target_height}{The matrix height is reduced to this number of rows
before plotting.
Useful to limit overplotting artefacts. It should roughtly be set to
the pixel height in the final heatmap.}

\item{summary_func}{function passed to \code{redimMatrix()}.
Usualy \code{mean}, but can be set to \code{median} or \code{max} for sparse
matrices.}

\item{n_core}{multicore option, passed to \code{redimMatrix()}.}

\item{pattern}{only if \code{rse} is of class GRanges.
A character vector of length 1 of a column prefixe
(can be regular expressions) that should match columns of \code{rse}.}
}
\value{
Display a plot.
}
\description{
Display a heatmap of an epigenetic track centered at
genomic anchors such as Transcription Start Sites or peak center.
}
\details{
The visualisation is centered on an anchor,
a set of genomic coordinated that can be transcription start sites or
peak center for example. Anchor coordinates are those of the
\code{RangedSummarizedExperiment} object used as an input
(hereafter \code{rse}).

Anchors are plotted from top to bottom in the same order as in \code{rse}.
One should sort \code{rse} before plotting if needed.

The matrix used to display the heatmap should be passed as
assay of \code{rse}. Such matrix can be obtained using
\code{EnrichedHeatmap::normalizeToMatrix()} for example.

This function scale reasonnably wells up to hundred thousands
of regions. Overplotting issues are solved by last-minute reduction of the
matrix size using \code{redimMatrix()}.
}
\examples{
data("stackepi")
plotStackProfile(stackepi,
                   target_height = 650,
                   zlim = c(0, 1),
                   palette = colorRampPalette(c("white", "dodgerblue", "black")),
                   title = "DNA methylation")

}
\seealso{
\code{\link[epistack]{plotAverageProfile}},
\code{\link[epistack]{plotEpistack}},
\code{\link[EnrichedHeatmap]{normalizeToMatrix}},
\code{\link[epistack]{plotStackProfileLegend}}
}
