% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epidecodeR.R
\name{makeplot}
\alias{makeplot}
\title{Generate CDF plot using epidecodeR object generated using epidecodeR function}
\usage{
makeplot(obj, type, lim, title, xlab, ylab)
}
\arguments{
\item{obj}{epidecodeR object - epidecodeR object generated using epidecodeR function}

\item{type}{char - Type of CDF plot to generate; Accepted values 't': theoretical CDF plot; 'e': empirical CDF plot; 'both': Creates both theoretical and empirical plots.    Default: both}

\item{lim}{vector - Upper and lower limits of log2FC for X-axis}

\item{title}{char - Title of the plot}

\item{xlab}{char - X-axis label}

\item{ylab}{char - Y-axis label}
}
\value{
A CDF plot
}
\description{
Generate CDF plot using epidecodeR object generated using epidecodeR function
}
\examples{
events<-system.file("extdata","NOMO-1_ref_peaks.bed", package="epidecodeR")
deg<-system.file("extdata", "FTOi.txt", package="epidecodeR")
epiobj<-epidecodeR(events=events,deg=deg,pval=0.05,param=3,ints=c(2,4))
makeplot(epiobj, lim = c(-10,10), xlab = "log2FC")
}
