% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodsEmapInternal.R
\encoding{UTF-8}
\name{validateCreateEnrichMapMultiArguments}
\alias{validateCreateEnrichMapMultiArguments}
\title{Validate arguments passed to createEnrichMapMultiBasic() function}
\usage{
validateCreateEnrichMapMultiArguments(
  gostObjectList,
  queryList,
  source,
  termIDs,
  removeRoot,
  showCategory,
  groupCategory,
  categoryLabel,
  categoryNode,
  line
)
}
\arguments{
\item{gostObjectList}{a \code{list} of \code{gprofiler2} objects that 
contain the results from an enrichment analysis. The list must contain at 
least 2 entries. The number of entries must correspond to the number of 
entries for the \code{queryList} parameter.}

\item{queryList}{a \code{list} of \code{character} strings representing the 
names of the queries that are going to be used to generate the graph. 
The query names must exist in the associated \code{gostObjectList} objects 
and follow the same order. The number of entries must correspond to the 
number of entries for the \code{gostObjectList} parameter.}

\item{source}{a \code{character} string representing the selected source 
that will be used to generate the network. To hand-pick the terms to be 
used, "TERM_ID" should be used and the list of selected term IDs should
be passed through the \code{termIDs} parameter. The possible sources are 
"GO:BP" for Gene Ontology Biological Process, "GO:CC" for Gene Ontology  
Cellular Component, "GO:MF" for Gene Ontology Molecular Function, 
"KEGG" for Kegg, "REAC" for Reactome, "TF" for TRANSFAC, "MIRNA" for 
miRTarBase, "CORUM" for CORUM database, "HP" for Human phenotype ontology
and "WP" for WikiPathways.}

\item{termIDs}{a \code{vector} of \code{character} strings that contains 
the term IDs retained for the creation of the network. This parameter is 
only used when \code{source} is set to "TERM_ID".}

\item{removeRoot}{a \code{logical} that specified if the root terms of 
the selected source should be removed (when present).}

\item{showCategory}{a positive \code{integer} or a \code{vector} of 
\code{characters} representing terms.  If a \code{integer}, the first 
\code{n} terms will be displayed. If \code{vector} of terms, 
the selected terms will be displayed.}

\item{groupCategory}{a \code{logical} indicating if the categories should 
be grouped.}

\item{categoryLabel}{a positive \code{numeric} representing the amount by 
which plotting category nodes label size should be scaled relative 
to the default (1).}

\item{categoryNode}{a positive \code{numeric} representing he amount by 
which plotting category nodes should be scaled relative to the default (1).}

\item{line}{a non-negative \code{numeric} representing the scale of line 
width.}
}
\value{
\code{TRUE} when all arguments are valid
}
\description{
Validate the arguments passed to createEnrichMapMultiBasic() 
function.
First, the object containing the enrichment results must correspond to a 
object created by  \code{gprofiler2} software. Second, the selected 
source must at least have one enriched term in the results. Then, if the
source is 'TERM_ID', the listed terms must be present in the enrichment
results.
}
\examples{

## Load the result of an enrichment analysis done with gprofiler2
data(parentalNapaVsDMSOEnrichment)
data(rosaNapaVsDMSOEnrichment)

## Check that all arguments are valid
enrichViewNet:::validateCreateEnrichMapMultiArguments(
    gostObjectList=list(parentalNapaVsDMSOEnrichment, 
                            rosaNapaVsDMSOEnrichment),
    queryList=list("parental_napa_vs_DMSO", "rosa_napa_vs_DMSO"), 
    source="GO:BP", termIDs=NULL, removeRoot=FALSE, 
    showCategory=20, groupCategory=FALSE, 
    categoryLabel=1.1, categoryNode=1, line=1.2)

}
\author{
Astrid Deschênes
}
\keyword{internal}
