% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getMethods.R
\docType{methods}
\name{betaCoef}
\alias{betaCoef}
\alias{betaCoef,deFit-method}
\title{Regression coefficients from full model fit}
\usage{
betaCoef(object)

\S4method{betaCoef}{deFit}(object)
}
\arguments{
\item{object}{\code{S4 object}: \code{\linkS4class{deFit}}}
}
\value{
\code{betaCoef} returns the regression coefficients for the full
 model fit.
}
\description{
Access the full model fitted coefficients of a
\code{\linkS4class{deFit}} object.
}
\examples{
# import data
library(splines)
data(kidney)
age <- kidney$age
sex <- kidney$sex
kidexpr <- kidney$kidexpr
cov <- data.frame(sex = sex, age = age)

# create models
null_model <- ~sex
full_model <- ~sex + ns(age, df = 4)

# create deSet object from data
de_obj <- build_models(data = kidexpr, cov = cov, null.model = null_model,
full.model = full_model)

# run fit_models to get model fits
de_fit <- fit_models(de_obj)

# extract beta coefficients
beta <- betaCoef(de_fit)

}
\author{
John Storey, Andrew Bass
}
\seealso{
\code{\link{fit_models}}
}

