% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R
\name{setOptionsList}
\alias{setOptionsList}
\title{setOptionsList}
\usage{
setOptionsList(
  object,
  cacheFlag = TRUE,
  evalFlag = TRUE,
  echoFlag = TRUE,
  warningFlag = FALSE,
  showMessages = FALSE,
  includeFlag = TRUE,
  collapseFlag = FALSE,
  purlFlag = TRUE,
  errorFlag = TRUE,
  messageFlag = TRUE,
  highlightFlag = TRUE,
  promptFlag = FALSE,
  stripWhiteFlag = TRUE,
  tidyFlag = FALSE
)
}
\arguments{
\item{object}{an easyreporting class object}

\item{cacheFlag}{boolean for caching chunk data (default TRUE)}

\item{evalFlag}{boolean for evaluating the code chunk in the compiled version
(default TRUE)}

\item{echoFlag}{boolean for showing the code chunk (default TRUE)}

\item{warningFlag}{boolean for showing the chunk warnings (default FALSE)}

\item{showMessages}{boolean for showing the chunk warnings in compiled
version (default FALSE)}

\item{includeFlag}{boolean for including the code chunk in the compiled
version (default TRUE)}

\item{collapseFlag}{boolean for collapsing the code chunk in the compiled
version (default FALSE),}

\item{purlFlag}{boolean for extracting the code chunk as R code in a separate
R file (default TRUE),}

\item{errorFlag}{boolean for including the error generated by the code chunk 
in the compiled version (default TRUE),}

\item{messageFlag}{boolean for including the code chunk messages in the compiled
version (default TRUE),}

\item{highlightFlag}{boolean for highlinghtinh the code chunk in the compiled
version (default TRUE),}

\item{promptFlag}{boolean for including a ">" for the code chunk in the compiled
version (default FALSE),}

\item{stripWhiteFlag}{boolean for removing the white spaces at beginning/end 
of the code chunk in the compiled version (default TRUE),}

\item{tidyFlag}{boolean for creating a tidy code chunk in the compiled
version (default FALSE).}
}
\value{
none
}
\description{
set an optionList to the class, it automatically sets the 
options for the rmarkdown file. Are useful for the 
interpretation/execution of the code chunks.
}
\examples{
\dontrun{
rd <- easyreporting(filenamePath="./project_report",
                        title="example_report", author=c("It's me"))

## setting default option
setOptionsList(rd)

## modifying only some options
rd <- setOptionsList(rd, warningFlag=TRUE, 
        showMessages=TRUE, includeFlag=TRUE)
}
}
