% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easyRNASeq-RnaSeqParam-accessors.R
\name{easyRNASeq RnaSeqParam accessors}
\alias{easyRNASeq RnaSeqParam accessors}
\alias{RnaSeqParam-accessors}
\alias{yieldSize,RnaSeqParam-method}
\alias{bamParam}
\alias{annotParam}
\alias{countBy}
\alias{precision}
\alias{countBy,RnaSeqParam-method}
\alias{precision,RnaSeqParam-method}
\alias{bamParam,RnaSeqParam-method}
\alias{annotParam,RnaSeqParam-method}
\alias{datasource,RnaSeqParam-method}
\alias{paired,RnaSeqParam-method}
\alias{stranded,RnaSeqParam-method}
\alias{strandProtocol,RnaSeqParam-method}
\title{Accessors for RnaSeqParam class}
\usage{
\S4method{yieldSize}{RnaSeqParam}(object)
}
\arguments{
\item{object}{An object derived from class \code{RnaSeqParam}.}
}
\value{
The value of the corresponding slot.
}
\description{
These functions and generics define `accessors` (to get and set values) for
\code{\linkS4class{RnaSeqParam}} objects within the \pkg{easyRNASeq} package.
Implemented are:
\itemize{
\item annotParam
\item bamParam
\item countBy
\item datasource
\item paired
\item precision
\item stranded
\item strandProtocol
\item yieldSize
}
}
\examples{
## create the necessary AnnotParam
annotParam <- AnnotParam(
                datasource=system.file(
                                "extdata",
                                "Dmel-mRNA-exon-r5.52.gff3",
                                package="RnaSeqTutorial"))

## create the RnaSeqParam
rsp <- RnaSeqParam(annotParam=annotParam)
## get the yieldSize Parameter
ysize <-yieldSize(rsp)

}
\seealso{
\itemize{
  \item The \code{\link[easyRNASeq:easyRNASeq-AnnotParam-class]{AnnotParam}} class
  \item The \code{\link[easyRNASeq:easyRNASeq-BamParam-class]{BamParam}} class
  \item The \code{\link[easyRNASeq:easyRNASeq-RnaSeqParam-class]{RnaSeqParam}} class
}
The \code{\link[easyRNASeq:easyRNASeq-BamParam-accessors]{BamParam yieldSize}} accessor
}
\author{
Nicolas Delhomme
}
\keyword{manip}
