% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IRanges-methods.R
\name{IRanges additional methods}
\alias{IRanges additional methods}
\alias{ranges}
\alias{ranges,RNAseq-method}
\title{Extension of the IRanges package}
\usage{
\S4method{ranges}{RNAseq}(x)
}
\arguments{
\item{x}{An object of the \code{\linkS4class{RNAseq}} class}
}
\value{
An \code{\linkS4class{IRangesList}} object, where the split
is performed by seqnames (\emph{e.g.} chromosomes).
}
\description{
Return the ranges of the genomic annotation.
}
\details{
It retrieves the object stored in the genomicAnnotation slot of the RNAseq
object and apply the \code{ranges} function on it.
}
\examples{

	\dontrun{
	library("RnaSeqTutorial")

	obj <- getAnnotation(
            AnnotParam(
              organism="Dmelanogaster",
              datasource=system.file(
    	          "extdata",
				        "Dmel-mRNA-exon-r5.52.gff3",
				        package="RnaSeqTutorial"),
  		        type="gff3"
  ))

	ranges(obj)
	}

}
\author{
Nicolas Delhomme
}
\keyword{methods}
