% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_TF_activity.R
\name{compute_TF_activity}
\alias{compute_TF_activity}
\title{Compute transcription factor activity from gene
expression using DoRothEA}
\usage{
compute_TF_activity(RNA_tpm = NULL, verbose = TRUE)
}
\arguments{
\item{RNA_tpm}{data.frame containing TPM values with HGNC symbols
in rows and samples in columns.}

\item{verbose}{logical value indicating whether to display messages
about the number of regulated
genes found in the gene expression data provided.}
}
\value{
A numeric matrix of activity scores with samples in rows
and TFs in columns.
}
\description{
Infers transcription factor (TF) activity from TPM bulk
gene expression using DoRothEA method from Garcia-Alonso et al.,
Genome Res, 2019.
}
\examples{
# using a SummarizedExperiment object
library(SummarizedExperiment)
# Using example exemplary dataset (Mariathasan et al., Nature, 2018)
# from easierData. Original processed data is available from
# IMvigor210CoreBiologies package.
library("easierData")

dataset_mariathasan <- easierData::get_Mariathasan2018_PDL1_treatment()
RNA_tpm <- assays(dataset_mariathasan)[["tpm"]]

# Select a subset of patients to reduce vignette building time.
pat_subset <- c(
  "SAM76a431ba6ce1", "SAMd3bd67996035", "SAMd3601288319e",
  "SAMba1a34b5a060", "SAM18a4dabbc557"
)
RNA_tpm <- RNA_tpm[, colnames(RNA_tpm) \%in\% pat_subset]

# Computation of TF activity (Garcia-Alonso et al., Genome Res, 2019)
tf_activity <- compute_TF_activity(
  RNA_tpm = RNA_tpm
)
}
\references{
Garcia-Alonso L, Holland CH, Ibrahim MM, Turei D,
Saez-Rodriguez J. "Benchmark and integration of resources for
the estimation of human transcription factor activities."
Genome Research. 2019. DOI: 10.1101/gr.240663.118.
}
