% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{residuals,dreamletResult-method}
\alias{residuals,dreamletResult-method}
\alias{residuals,dreamletResult,dreamletResult-method}
\title{Extract residuals from \code{dreamletResult}}
\usage{
\S4method{residuals}{dreamletResult}(object, y, ..., type = c("response", "pearson"))
}
\arguments{
\item{object}{\code{dreamletResult} object}

\item{y}{\code{dreamletProcessedData} object}

\item{...}{other arguments}

\item{type}{compute either \code{"response"} residuals or \code{"pearson"} residuals.}
}
\value{
residuals from model fit
}
\description{
Extract residuals from \code{dreamletResult}
}
\details{
\code{"response"} residuals are the typical residuals returned from \code{lm()}. \code{"pearson"} residuals divides each residual value by its estimated standard error.  This requires specifying \code{y}
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# voom-style normalization
res.proc <- processAssays(pb, ~group_id)

# Differential expression analysis within each assay,
# evaluated on the voom normalized data
res.dl <- dreamlet(res.proc, ~group_id)

# extract typical residuals for each assay (i.e. cell type)
# Return list with entry for each assay with for retained samples and genes
resid.lst <- residuals(res.dl)

# Get Pearson residuals:
# typical residuals scaled by the standard deviation
residPearson.lst <- residuals(res.dl, res.proc, type = "pearson")

}
