% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCellComposition.R
\name{plotCellComposition}
\alias{plotCellComposition}
\alias{plotCellComposition,SingleCellExperiment-method}
\alias{plotCellComposition,matrix-method}
\alias{plotCellComposition,data.frame-method}
\title{Bar plot of cell compositions}
\usage{
plotCellComposition(obj, col, width = NULL)

\S4method{plotCellComposition}{SingleCellExperiment}(obj, col, width = NULL)

\S4method{plotCellComposition}{matrix}(obj, col, width = NULL)

\S4method{plotCellComposition}{data.frame}(obj, col, width = NULL)
}
\arguments{
\item{obj}{matrix of [cells] x [samples] or \code{SingleCellExperiment} from \code{aggregateToPseudoBulk}}

\item{col}{array of colors.  If missing, use default colors.  If \code{names(col)} is the same as \code{arrayNames(obj)}, then colors will be assigned by assay name#'}

\item{width}{specify width of bars}
}
\value{
Barplot showing cell fractions
}
\description{
Bar plot of cell compositions
}
\examples{

library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# show cell composition bar plots
plotCellComposition(pb)

# extract cell counts
df_cellCounts <- cellCounts(pb)

# show cell composition bar plots
plotCellComposition(df_cellCounts)

}
