% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicate_classification.R
\name{classify_genes}
\alias{classify_genes}
\title{Classify genes into unique modes of duplication}
\usage{
classify_genes(gene_pairs_list = NULL)
}
\arguments{
\item{gene_pairs_list}{List of classified gene pairs as returned
by \code{classify_gene_pairs()}.}
}
\value{
A list of 2-column data frames with variables \strong{gene}
and \strong{type} representing gene ID and duplication type, respectively.
}
\description{
Classify genes into unique modes of duplication
}
\details{
If a gene is present in pairs with different duplication modes, the gene
is classified into a unique mode of duplication following the order
of priority indicated in the levels of the factor \strong{type}.

For scheme "binary", the order is SD > SSD.
For scheme "standard", the order is SD > TD > PD > DD.
For scheme "extended", the order is SD > TD > PD > TRD > DD.
For scheme "full", the order is SD > TD > PD > rTRD > dTRD > DD.
}
\examples{
data(fungi_kaks)
scerevisiae_kaks <- fungi_kaks$saccharomyces_cerevisiae

cols <- c("dup1", "dup2", "type")
gene_pairs_list <- list(Scerevisiae = scerevisiae_kaks[, cols])

class_genes <- classify_genes(gene_pairs_list)
}
