% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iqrxFilter.R
\name{iqrxFilter}
\alias{iqrxFilter}
\title{iqrxFilter Function to filter expression data within an s.e.
object.}
\usage{
iqrxFilter(se, iqr_multi = 1.5, MEDIAN = FALSE, na.rm = TRUE)
}
\arguments{
\item{se}{A SummarizedExperiment object.}

\item{iqr_multi}{Numeric multiplier; removes any outliers that are iqr_multi
times the mid-50 percentile distance greater or less than the 25th and 75th
percentiles, by default}

\item{MEDIAN}{Boolean, Calculate RowMeans or RowMedians.}

\item{na.rm}{Boolean, NA removal.}
}
\value{
Returns a filtered SummarizedExperiment object.
}
\description{
This function filters the expression of the supplied se
object. iqrxFilter is a filtering function used to remove rows (genes) of
various expression data.
}
\details{
This function filters the expression of the supplied object,
based on a selected percentage cutoff and selected interquartile range
multiplier. The function iqrxFilter will: 1) log-base two transform all RPKM
values (obligatory); (2) remove any outliers that were 1.5 times the mid-50
percentile distance greater or less than the 75th and 25th percentiles
(by default), respectively; and (3) uses mean values and instead of median
values (by default).
}
\examples{
data(hmel.se)
f_se <- iqrxFilter(se)
}
\references{
Jue et al. BMC Genomics 2013 14:150
}
\author{
AJ Vaestermark, JR Walters.
}
