% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_fxns.R
\name{mean_ligand_expression}
\alias{mean_ligand_expression}
\title{Calculate mean ligand expression as a data frame for plotting in circos plot}
\usage{
mean_ligand_expression(x, ligands, cell_ident, cell_barcodes, destination)
}
\arguments{
\item{x}{Gene by cell expression matrix}

\item{ligands}{Character vector of ligand genes to be quantified}

\item{cell_ident}{Vector of cell type (identity) names for which to calculate mean ligand gene expression}

\item{cell_barcodes}{Vector of cell barcodes (colnames of x) belonging to cell_ident to calculate mean expression across}

\item{destination}{Name of the receptor with which each ligand interacts}
}
\value{
A data frame of ligand expression targeting the specified receptor
}
\description{
Creates a data frame of mean ligand expression for use in plotting a circos
plot of ligand expression and saving tables of mean expression.
us
}
\examples{
example(build_domino, echo = FALSE)
counts <- dom_counts(pbmc_dom_built_tiny)
mean_exp <- mean_ligand_expression(counts,
 ligands = c("PTPRC", "FASLG"), cell_ident = "CD14_monocyte",
 cell_barcodes = colnames(counts), destination = "FAS")

}
