% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dom_network_items}
\alias{dom_network_items}
\title{Access all features, receptors, or ligands present in a signaling network.}
\usage{
dom_network_items(dom, clusters = NULL, return = NULL)
}
\arguments{
\item{dom}{a domino object containing a signaling network (i.e. \code{\link[=build_domino]{build_domino()}} was run)}

\item{clusters}{vector indicating clusters to collate network items from. If left as NULL then all clusters will be included.}

\item{return}{string indicating whether to collate "features", "receptors", or "ligands". If "all" then a list of all three will be returned.}
}
\value{
A vector containing all features, receptors, or ligands in the data set or a list containing all three.
}
\description{
This function collates all of the features, receptors, or ligands found in a
signaling network anywhere in a list of clusters. This can be useful for
comparing signaling networks across two separate conditions. In order to run
this \code{\link[=build_domino]{build_domino()}} must be run on the object previously.
}
\examples{
example(build_domino, echo = FALSE)
monocyte_receptors <- dom_network_items(pbmc_dom_built_tiny, "CD14_monocyte", "receptors")
all_tfs <- dom_network_items(pbmc_dom_built_tiny, return = "features")

}
