% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.reductions.R
\name{getReductions}
\alias{getReductions}
\title{Returns the names of all dimensionality reduction slots of a target object.}
\usage{
getReductions(object)
}
\arguments{
\item{object}{A Seurat, SingleCellExperiment, or SummarizedExperiment object.}
}
\value{
A string vector of the names of all dimensionality reduction slots of the \code{object}.
These represent the options for the \code{reduction.use} input of \code{\link{dittoDimPlot}}.
}
\description{
Returns the names of all dimensionality reduction slots of a target object.
}
\examples{

example("addDimReduction", echo = FALSE)

# To see all metadata slots of an object
getReductions(myRNA)

}
\author{
Daniel Bunis
}
