% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene-getters.R
\name{gene}
\alias{gene}
\title{Returns the expression values of a gene for all cells/samples}
\usage{
gene(
  gene,
  object,
  assay = .default_assay(object),
  slot = .default_slot(object),
  adjustment = NULL,
  adj.fxn = NULL,
  swap.rownames = NULL
)
}
\arguments{
\item{gene}{quoted "gene" name = REQUIRED. the gene whose expression data should be retrieved.}

\item{object}{A Seurat, SingleCellExperiment, or SummarizedExperiment object.}

\item{assay, slot}{single strings or integers (SCEs and SEs) or a vector of such values that set which expression data to use.
See \code{\link{GeneTargeting}} for specifics and examples -- Seurat and SingleCellExperiment objects deal with these differently, and functionality additions in dittoSeq have led to some minimal divergence from the native methodologies.}

\item{adjustment}{Should expression data be used directly (default) or should it be adjusted to be
\itemize{
\item{"z-score": scaled with the scale() function to produce a relative-to-mean z-score representation}
\item{"relative.to.max": divided by the maximum expression value to give percent of max values between [0,1]}
}}

\item{adj.fxn}{A function which takes a vector (of metadata values) and returns a vector of the same length.

For example, \code{function(x) \{log2(x)\}} or \code{as.factor}}

\item{swap.rownames}{optionally named string or string vector.
For SummarizedExperiment or SingleCellExperiment objects, its value(s) specifies the column name of rowData(object) to be used to identify features instead of rownames(object).
When targeting multiple modalities (alternative experiments), names can be used to specify which level / alternative experiment (use 'main' for the top-level) individual values should be used for.
See \code{\link{GeneTargeting}} for more specifics and examples.}
}
\value{
Returns the expression values of a gene for all cells/samples.
}
\description{
Returns the expression values of a gene for all cells/samples
}
\examples{
example(importDittoBulk, echo = FALSE)
gene("gene1", object = myRNA, assay = "counts")

# z-scored
gene("gene1", object = myRNA, assay = "counts",
    adjustment = "z-score")

# Log2'd
gene("gene1", object = myRNA, assay = "counts",
    adj.fxn = function(x) \{log2(x)\})

# To see expression of the gene for the default assay that dittoSeq would use
# leave out the assay input
# (For this object, the default assay is the logcounts assay)
gene("gene1", myRNA)

# Seurat (raw counts)
if (!requireNamespace("Seurat")) {
    gene("CD14", object = Seurat::pbmc, assay = "RNA", slot = "counts")
}

}
\author{
Daniel Bunis
}
