% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/conditional.R
\docType{methods}
\name{conditional}
\alias{conditional}
\alias{conditional,diggit-method}
\title{Conditional analysis of CNVs}
\usage{
conditional(x, ...)

\S4method{conditional}{diggit}(x, pheno = "cond", group1, group2 = NULL,
  cnv = 0.2, mr = 0.01, mr.adjust = c("none", "fdr", "bonferroni"),
  modul = 0.01, modul.adjust = c("none", "fdr", "bonferroni"),
  fet.pval = 0.05, cores = 1, verbose = TRUE)
}
\arguments{
\item{x}{Object of class diggit}

\item{...}{Additional parameters to pass to the function}

\item{pheno}{Character string indicating the feature for sample groups}

\item{group1}{Character string indicating the treatment group}

\item{group2}{Optional character string indicating the reference group}

\item{cnv}{Single number or vector of two numbers indicating the thresholds for CNVs}

\item{mr}{Either vector of character strings indicating the MR genes, or number indicating the corrected p-value threshold for selecting the MRs}

\item{mr.adjust}{Character string indicating the multiple-hypothesis correction to apply to the MR p-values}

\item{modul}{Number indicating the p-value threshold for a modulator to be considered associated with the MR activity}

\item{modul.adjust}{Character string indicating the multiple-hypothesis correction to apply to the aQTL results}

\item{fet.pval}{Number indicating the FET p-value threshold for the association between CNVs and sample groups}

\item{cores}{Integer indicating the number of cores to use (1 for Windows-based systems)}

\item{verbose}{Logical, whether progress should be reported}
}
\value{
Object of class diggit with conditional analysis results
}
\description{
This function performs the conditional analysis of fCNVs
}
\examples{
data(gbm.expression, package="diggitdata")
data(gbm.cnv, package="diggitdata")
data(gbm.aracne, package="diggitdata")
dobj <- diggitClass(expset=gbmExprs, cnv=gbmCNV, regulon=gbmTFregulon)
dobj <- fCNV(dobj)
dobj <- aqtl(dobj, mr=c("CEBPD", "STAT3"), fcnv.adjust="fdr", verbose=FALSE)
dobj <- conditional(dobj, pheno="subtype", group1="MES", group2="PN", mr="STAT3", verbose=FALSE)
dobj
}

