% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_graph.R
\name{generate_graph}
\alias{generate_graph}
\title{Generate a random graph}
\usage{
generate_graph(
    fun_gen,
    param_gen,
    class_label = NULL,
    class_attr = .default_graph_param(),
    fun_curate = .connect_undirected_graph,
    seed = NULL
)
}
\arguments{
\item{fun_gen}{function to generate the graphs. Typically from
\pkg{igraph}, like \code{\link[igraph:sample_pa]{barabasi.game}},
\code{\link[igraph:sample_smallworld]{watts.strogatz.game}},
\code{\link[igraph]{erdos.renyi.game}},
\code{\link[igraph]{make_lattice}}, etc.}

\item{param_gen}{list with parameters to pass to \code{fun_gen}}

\item{class_label}{character vector with length equal to
the number of nodes in the graph to generate.
If left to \code{NULL}, the default classes  are
\code{c("source", "filler", "end")} with proportions of
\code{c(0.05, 0.45, 0.5)}.}

\item{class_attr}{data.frame with vertex classes as rownames and a column
for each vertex attribute. The name of the column will be used as the
attribute name.}

\item{fun_curate}{function to apply to the graph before returning it.
Can be set to \code{identity} or \code{NULL} to skip this step.
By default, the graph is connected: nodes not belonging to the
largest connected component are randomly wired to a node in it.}

\item{seed}{numeric, seed for random number generator}
}
\value{
An \pkg{igraph} object
}
\description{
Function \code{generate_graph} generates a random network
using \pkg{igraph} graph generators. Several models are
available, and
}
\examples{
g <- generate_graph(
    fun_gen = igraph::barabasi.game,
    param_gen = list(n = 100, m = 3, directed = FALSE),
    seed = 1)
g

}
