% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{summary}
\alias{summary}
\alias{summary,data.frame-method}
\title{Summarize classification results of a Demuxmix model}
\usage{
summary(object, ...)
}
\arguments{
\item{object}{An object of class \code{\link{Demuxmix}}.}

\item{...}{Additional parameters (ignored).}
}
\value{
A \code{data.frame} with one row per class showing the number
  of droplets in the class (NumObs), the relative frequency of the class
  (RelFreq), the median probability with which a droplet was assigned to the
  class (MedProb), the estimated number of droplets falsely assigned to the
  class (ExpFPs), and the corresponding estimated false discovery rate (FDR).
}
\description{
This method takes the demultiplexing results from an HTO experiment
returned by \code{\link{demuxmix}} and returns a \code{data.frame}
summarizing the classification results and expected error rates.
}
\details{
Results are summarized for the individual HTOs, for all
  singlets combined, for all multiplets combined, and for the negative
  class. Relative frequencies are calculated after excluding the
  "uncertain" class. The estimated number of false positive droplets and the
  estimated FDR are based on several assumptions, one of which is the
  independence of the HTO counts from different hashtags. This
  assumption is unlikely for real data where all HTO counts
  are obtained from the same droplet. Usually, the positive
  correlation among HTOs causes an overestimation of multiplets and
  negative/empty droplets. Error rates are more accurate when regression
  mixture models are used since the number of detected genes explains some
  of the positive correlation between HTOs.
}
\examples{
set.seed(2642)
simdata <- dmmSimulateHto(class = rbind(c(rep(TRUE, 220), rep(FALSE, 200)),
                                        c(rep(FALSE, 200), rep(TRUE, 220))))

dmm <- demuxmix(simdata$hto, rna = simdata$rna)
summary(dmm)
pAcpt(dmm) <- 0.05
summary(dmm)

}
\seealso{
\code{\link{demuxmix}}
}
