% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{plotDmmPosteriorP}
\alias{plotDmmPosteriorP}
\alias{plotDmmPosteriorP,Demuxmix,missing-method}
\alias{plotDmmPosteriorP,Demuxmix,ANY-method}
\title{Plotting a histogram of posterior probabilities}
\usage{
plotDmmPosteriorP(object, hto, bins = 50)
}
\arguments{
\item{object}{An object of class \code{\link{Demuxmix}}.}

\item{hto}{Optional vector specifying a subset of HTOs in \code{object} which
should be used by this function.}

\item{bins}{The number of bins of the histogram.}
}
\value{
An object of class \code{ggplot} is returned, if only one HTO is
  plotted. If several HTOs are plotted simultaneously, a grid of plots is
  returned.
}
\description{
This methods plots a histogram of posterior probabilities obtained
from the given mixture model. The posterior probabilities indicate whether
the droplet likely contains a cell labeled by the respective HTO.
The mixture model passed to this function must be generated by
\code{\link{demuxmix}}.
}
\details{
The histogram visualizes how well the positive droplets can be
  separated from the negative droplets. Ideally, the histogram shows many
  droplets with a posterior probability very close to 0 and many droplets
  close to 1, but no or very few droplets with probabilities somewhere in
  between. The histogram can be useful for guiding the selection of the
  acceptance probability \code{pAcpt}.
}
\examples{
set.seed(2642)
simdata <- dmmSimulateHto(class = rbind(c(rep(TRUE, 220), rep(FALSE, 200)),
                                        c(rep(FALSE, 200), rep(TRUE, 220))))

dmm <- demuxmix(simdata$hto, model = "naive")
\donttest{plotDmmPosteriorP(dmm)}

dmmreg <- demuxmix(simdata$hto, rna = simdata$rna, model = "auto")
\donttest{plotDmmPosteriorP(dmmreg)}
\donttest{plotDmmPosteriorP(dmmreg, hto = 1)}

}
\seealso{
\code{\link{demuxmix}}
}
