% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shearwaterML.R
\name{qvals2Vcf}
\alias{qvals2Vcf}
\title{Function to create a \code{\link{VCF}} object with variant calls from an array of q-values.}
\usage{
qvals2Vcf(
  qvals,
  counts,
  regions,
  samples = 1:nrow(counts),
  err = NULL,
  mu = NULL,
  cutoff = 0.05,
  mvcf = TRUE
)
}
\arguments{
\item{qvals}{array of q-values from \code{\link{betabinLRT}}.}

\item{counts}{array of counts from \code{\link{loadAllData}}.}

\item{regions}{\code{\link{GRanges}} with the regions corresponding to counts and qvals.}

\item{samples}{vector of samples names.}

\item{err}{Optional matrix of error rates, otherwise recomputed from counts.}

\item{mu}{Optional matrix of relative frequencies, otherwise recomputed from counts.}

\item{cutoff}{Cutoff for the q-values below which a variant is considered to be true (default = 0.05)}

\item{mvcf}{boolean flag, if TRUE compute a large VCF with as many genotype columns as samples. Default TRUE. Otherwise use duplicate rows and only one genotype column. The sample is then provided by the info:PD field. Can be inefficient for large sample sizes.}
}
\value{
A \code{\link{VCF}} object
}
\description{
This function thresholds the q-values computed by the shearwater algorithm and creates a \code{\link{VCF}} object as output.
}
\note{
Experimental code, subject to changes
}
\author{
mg14
}
