% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decontPro.R
\name{decontPro}
\alias{decontPro}
\alias{decontPro,SingleCellExperiment-method}
\alias{decontPro,Seurat-method}
\alias{decontPro,ANY-method}
\title{Decontaminate using decontPro}
\usage{
decontPro(filtered_counts, cell_type, ...)

\S4method{decontPro}{SingleCellExperiment}(
  filtered_counts,
  cell_type,
  delta_sd = 2e-05,
  background_sd = 2e-06,
  ambient_counts = NULL,
  ...
)

\S4method{decontPro}{Seurat}(
  filtered_counts,
  cell_type,
  delta_sd = 2e-05,
  background_sd = 2e-06,
  ambient_counts = NULL,
  ...
)

\S4method{decontPro}{ANY}(
  filtered_counts,
  cell_type,
  delta_sd = 2e-05,
  background_sd = 2e-06,
  ambient_counts = NULL,
  ...
)
}
\arguments{
\item{filtered_counts}{Count matrix NxM (feature x droplet) with only
filtered droplets after cell calling. If this is a
\linkS4class{SingleCellExperiment} or a \linkS4class{Seurat} object,
expect \code{counts} in the assay slot.}

\item{cell_type}{1xM 1-based integer vector indicating cell type of each
droplet.}

\item{...}{Additional arguments for generics.}

\item{delta_sd}{Prior variance for ambient contamination level.
Default to 2e-5.}

\item{background_sd}{Prior variance for background contamination level.
Default to 2e-6.}

\item{ambient_counts}{Count matrix NxM (feature x droplet) with only ambient
droplets. Similar to \code{filtered_counts} param, if it is a wrapper object,
expect \code{counts} in the assay slot. Default to NULL.}
}
\value{
A list containing decontaminated counts, and estimated parameters.
}
\description{
Decontaminate using decontPro
}
\examples{
# Simulated count matrix with 100 features x 10 droplets
counts <- matrix(sample(1:10,
                        1000,
                        replace = TRUE),
                 ncol = 10)

# Cell type indicator
k <- c(1, 1, 2, 2, 2, 3, 3, 4, 4, 4)

# Simulated ambient count matrix (optional input)
ambient_counts <- matrix(sample(1:2,
                        1000,
                        replace = TRUE),
                 ncol = 10)

# Decontamination
out <- decontPro(counts, k, 1e-2, 1e-2, ambient_counts)

# Decontaminated counts
decontaminated_counts <- out$decontaminated_counts
}
