% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions_for_class_checks.R
\name{isShiraishiSet}
\alias{isShiraishiSet}
\title{isShiraishiSet}
\usage{
isShiraishiSet(x)
}
\arguments{
\item{x}{Object to be checked.}
}
\value{
Logical value (true or false).
}
\description{
`isShiraishiSet()` checks whether the input object is a set (list) of
numeric objects compatible with the Shiraishi format (matrices or
data.frames of probabilities; 6 columns, each row sums up to 1). NOTE:
These can also be genomes compatible with the Shiraishi format!
}
\examples{

### get Alexandrov signatures from COSMIC
signAlexandrov <- readAlexandrovSignatures()

### convert them to the Shiraishi model
signShiraishi <- convertAlexandrov2Shiraishi(signAlexandrov)

isShiraishiSet(signShiraishi)
}
\references{
\url{http://rmpiro.net/decompTumor2Sig/}\cr
Krueger, Piro (2019) decompTumor2Sig: Identification of mutational
signatures active in individual tumors. BMC Bioinformatics
20(Suppl 4):152.\cr
}
\seealso{
\code{\link{decompTumor2Sig}}\cr
\code{\link{isSignatureSet}}\cr
\code{\link{readShiraishiSignatures}}
}
\author{
Rosario M. Piro\cr Politecnico di Milano\cr Maintainer: Rosario
M. Piro\cr E-Mail: <rmpiro@gmail.com> or <rosariomichael.piro@polimi.it>
}
