% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddPCRclust.R
\name{readTemplate}
\alias{readTemplate}
\title{Read a template file from disk}
\usage{
readTemplate(template)
}
\arguments{
\item{template}{A csv file containing information about the individual ddPCR runs. 
An example template is provided with this package. For more information, please check the vignette or the repository on github.}
}
\value{
\item{annotations}{The metatdata provided in the header of the template. It contains four fields: \cr
\code{Name} The name given to this ddPCR experiment \cr
\code{Ch1} Color channel 1 (usually HEX) \cr
\code{Ch2} Color channel 2 (usually FAM) \cr
\code{descriptions} Additional descriptions about this ddPCR experiment (e.g. date, exprimentor, etc.)}
\item{template}{A parsed dataframe containing the template.}
}
\description{
This function reads a template file for ddPCRclust from disk and returns a run template and annotations.
Please refer to the vignette for information on how this file need to be formatted.
}
\examples{
# Read template
exampleFiles <- list.files(paste0(find.package('ddPCRclust'), '/extdata'), full.names = TRUE)
template <- readTemplate(exampleFiles[9])

}
