% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multtest_adjust.R
\name{dcAdjust}
\alias{dcAdjust}
\title{Adjust for multiple testing in differential association analysis}
\usage{
dcAdjust(dcpvals, f = stats::p.adjust, ...)
}
\arguments{
\item{dcpvals}{a matrix, the result of the \code{dcTest} function. The
results should be passed as produced by the function and not modified in
intermediate steps}

\item{f}{a function, the function to be used for adjustment. \code{p.adjust}
from the \code{stats} package is the default with the specific adjustment
method 'fdr' used. The range of available methods can be accessed using
\code{p.adjust.methods}. Custom functions should accept a numeric vector of
p-values as the first argument}

\item{...}{additional parameters to the adjustment function such as
\code{method}}
}
\value{
a matrix, of adjusted p-values (or scores in the case of DiffCoEx and
  EBcoexpress) representing significance of differential associations.
}
\description{
Adjust for multiple hypothesis testing after performing
  statistical tests  using \code{dcTest}. This can be performed using a
  method provided by the users. \code{p.adjust} is used by default.
}
\details{
Ensure that the p-value matrix passed to this function is the one
  produced by \code{dcTest}. Any modification to the result matrix will
  result in failure of the function.

  This method applies the adjustment method only to one triangle of the
  matrix to ensure adjustment is not performed for duplicated tests
  (symmetric matrix). As results from the DiffCoEx and EBcoexpress do not
  produce p-values, this method does not change anything thereby returning
  the original matrix.
}
\examples{
x <- matrix(rnorm(60), 2, 30)
cond <- rep(1:2, 15)
zscores <- dcScore(x, cond)
pvals <- dcTest(zscores, emat = x, condition = cond)
dcAdjust(pvals, p.adjust, method = 'fdr')

}
\seealso{
\code{\link{dcTest}} \code{\link[stats]{p.adjust}}
}
