# Generated by roxytest: do not edit by hand!

# File R/read_data.R: @tests

c("test_that(\"Function validate_otu() @ L146\", {\n  df <- \n    read_file(system.file(\"extdata\", \"metaHIV_counts.txt\", package = \"dar\"))\n  \n  expect_invisible(validate_otu(df))\n  expect_error(validate_otu(dplyr::select(df, -1)))\n  expect_error(validate_otu(dplyr::mutate(\n    df, otu_id = ifelse(otu_id == \"Otu_1\", NA_character_, otu_id)\n  )))\n  expect_error(validate_otu(dplyr::mutate(\n    df, otu_id = ifelse(otu_id == \"Otu_1\", \"Otu_2\", otu_id)\n  )))\n  expect_error(validate_otu(dplyr::mutate(df, dplyr::across(2, as.character))))\n  expect_error(validate_otu(dplyr::mutate(df, dplyr::across(\n   2, ~ ifelse(.x == 0, NA_integer_, .x)\n  ))))\n  expect_error(validate_otu(dplyr::mutate(df, dplyr::across(2, ~ .x * -1))))\n})\n", 
"test_that(\"Function validate_otu() @ L146\", {\n  df <- \n    read_file(system.file(\"extdata\", \"metaHIV_metadata.txt\", package = \"dar\"))\n  \n  expect_s3_class(validate_sample_data(df), c(\"tbl_df\", \"tbl\", \"data.frame\"))\n  expect_equal(dim(df), c(156, 4))\n  expect_error(validate_sample_data(dplyr::select(df, -1)))\n  expect_error(validate_sample_data(dplyr::mutate(\n    df, sample_id = ifelse(sample_id == \"Sample_169\", NA_character_, sample_id)\n  )))\n  expect_error(validate_sample_data(dplyr::mutate(\n    df, sample_id = ifelse(sample_id == \"Sample_169\", \"Sample_162\", sample_id)\n  )))\n  expect_error(validate_sample_data(dplyr::mutate(df, sample_id = 1:nrow(df))))\n})\n", 
"test_that(\"Function validate_otu() @ L146\", {\n  df <- read_file(system.file(\"extdata\", \"metaHIV_taxas.txt\", package = \"dar\"))\n  \n  expect_s3_class(validate_tax_table(df), c(\"tbl_df\", \"tbl\", \"data.frame\"))\n  expect_equal(dim(df), c(451, 8))\n  expect_error(validate_tax_table(dplyr::select(df, -1)))\n  expect_error(validate_tax_table(dplyr::mutate(\n    df, otu_id = ifelse(otu_id == \"Otu_1\", NA_character_, otu_id)\n  )))\n  expect_error(validate_tax_table(dplyr::mutate(\n    df, otu_id = ifelse(otu_id == \"Otu_1\", \"Otu_2\", otu_id)\n  )))\n  expect_error(validate_tax_table(\n    dplyr::mutate(df, dplyr::across(2, as.factor))\n  ))\n  expect_error(validate_tax_table(dplyr::mutate(df, otu_id = 1:nrow(df))))\n})\n", 
"test_that(\"Function validate_otu() @ L146\", {\n  ## phyloseq validation\n  phy <-\n    system.file(\"extdata\", \"metaHIV_phy.rds\", package = \"dar\") |>\n    read_phyloseq()\n  \n  no_tax_phy <- \n    phyloseq::phyloseq(phyloseq::otu_table(phy), phyloseq::sample_data(phy))\n  no_sam_phy <- \n    phyloseq::phyloseq(phyloseq::otu_table(phy), phyloseq::tax_table(phy))\n  only_otu_phy <- phyloseq::phyloseq(phyloseq::otu_table(phy))\n  \n  expect_error(validate_phyloseq(\n    read_file(system.file(\"extdata\", \"metaHIV_taxas.txt\", package = \"dar\")), \n    slots = \"\"\n  ))\n  expect_s4_class(validate_phyloseq(phy), \"phyloseq\")\n  expect_s4_class(validate_phyloseq(no_sam_phy, \"tax_table\"), \"phyloseq\")\n  expect_s4_class(validate_phyloseq(no_tax_phy, \"sample_data\"), \"phyloseq\")\n  expect_s4_class(validate_phyloseq(only_otu_phy, \"\"), \"otu_table\")\n  expect_error(validate_phyloseq(no_tax_phy))\n  expect_error(validate_phyloseq(no_sam_phy))\n  expect_error(validate_phyloseq(only_otu_phy))\n  expect_error(validate_phyloseq(no_tax_phy, \"tax_table\"))\n  expect_error(validate_phyloseq(no_sam_phy, \"sample_data\"))\n})\n", 
"test_that(\"Function validate_otu() @ L146\", {\n  ## File no exists and bad file extension\n  expect_error(read_file(\"asdfas.tx\"))\n})\n")

test_that("Function read_data() @ L58", {
  ## read phyloseq from rds file
  good_file <- system.file("extdata", "metaHIV_phy.rds", package = "dar")
  bad_file <- system.file("extdata", "invented_file.rds", package = "dar")
  expect_s4_class(read_data(good_file), "phyloseq")
  expect_error(read_data(bad_file))
  
  ## read phyloseq from multiple files
  good_files <- c(
    system.file("extdata", "metaHIV_counts.txt", package = "dar"),
    system.file("extdata", "metaHIV_metadata.txt", package = "dar"),
    system.file("extdata", "metaHIV_taxas.txt", package = "dar")
  )
  expect_s4_class(read_data(good_files), "phyloseq") |> 
    expect_snapshot()
  
  only_two_files <- c(
    system.file("extdata", "metaHIV_counts.txt", package = "dar"),
    system.file("extdata", "metaHIV_metadata.txt", package = "dar")
  )
  expect_error(read_data(only_two_files))
  
  duplicated_files <- c(
    system.file("extdata", "metaHIV_counts.txt", package = "dar"),
    system.file("extdata", "metaHIV_metadata.txt", package = "dar"),
    system.file("extdata", "metaHIV_metadata.txt", package = "dar")
  )
  expect_error(read_data(duplicated_files))
})

